/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.queue;

import com.carrotsearch.hppc.BitSet;
import java.util.PrimitiveIterator;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class HugeLongPriorityQueue
implements PrimitiveLongIterable {
    private final long capacity;
    private BitSet costKeys;
    private HugeLongArray heap;
    private long size = 0L;
    protected HugeDoubleArray costValues;

    public static MemoryEstimation memoryEstimation() {
        return MemoryEstimations.builder(HugeLongPriorityQueue.class).perNode("heap", HugeLongArray::memoryEstimation).perNode("costs", HugeDoubleArray::memoryEstimation).perNode("keys", MemoryUsage::sizeOfBitset).build();
    }

    protected HugeLongPriorityQueue(long capacity) {
        long heapSize = 0L == capacity ? 2L : capacity + 1L;
        this.capacity = capacity;
        this.costKeys = new BitSet(capacity);
        this.heap = HugeLongArray.newArray(heapSize);
        this.costValues = HugeDoubleArray.newArray(capacity);
    }

    public void add(long element, double cost) {
        assert (element < this.capacity);
        this.addCost(element, cost);
        ++this.size;
        this.heap.set(this.size, element);
        this.upHeap(this.size);
    }

    public void set(long element, double cost) {
        assert (element < this.capacity);
        if (this.addCost(element, cost)) {
            this.update(element);
        } else {
            ++this.size;
            this.heap.set(this.size, element);
            this.upHeap(this.size);
        }
    }

    public double cost(long element) {
        return this.costValues.get(element);
    }

    public boolean containsElement(long element) {
        return this.costKeys.get(element);
    }

    public long top() {
        return this.heap.get(1L);
    }

    public long pop() {
        if (this.size > 0L) {
            long result = this.heap.get(1L);
            this.heap.set(1L, this.heap.get(this.size));
            --this.size;
            this.downHeap(1L);
            this.removeCost(result);
            return result;
        }
        return -1L;
    }

    public long size() {
        return this.size;
    }

    public void release() {
        this.size = 0L;
        this.heap = null;
        this.costKeys = null;
        this.costValues.release();
    }

    protected abstract boolean lessThan(long var1, long var3);

    private boolean addCost(long element, double cost) {
        boolean elementExists = this.costKeys.get(element);
        this.costKeys.set(element);
        this.costValues.set(element, cost);
        return elementExists;
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    public void clear() {
        this.size = 0L;
        this.costKeys.clear();
    }

    private long findElementPosition(long element) {
        long limit = this.size + 1L;
        HugeLongArray data = this.heap;
        HugeCursor<long[]> cursor = data.initCursor(data.newCursor(), 1L, limit);
        while (cursor.next()) {
            int i;
            long[] internalArray = (long[])cursor.array;
            int localLimit = cursor.limit - 4;
            for (i = cursor.offset; i <= localLimit; i += 4) {
                if (internalArray[i] == element) {
                    return (long)i + cursor.base;
                }
                if (internalArray[i + 1] == element) {
                    return (long)(i + 1) + cursor.base;
                }
                if (internalArray[i + 2] == element) {
                    return (long)(i + 2) + cursor.base;
                }
                if (internalArray[i + 3] != element) continue;
                return (long)(i + 3) + cursor.base;
            }
            while (i < cursor.limit) {
                if (internalArray[i] == element) {
                    return (long)i + cursor.base;
                }
                ++i;
            }
        }
        return 0L;
    }

    private boolean upHeap(long origPos) {
        long i = origPos;
        long node = this.heap.get(i);
        for (long j = i >>> 1; j > 0L && this.lessThan(node, this.heap.get(j)); j >>>= 1) {
            this.heap.set(i, this.heap.get(j));
            i = j;
        }
        this.heap.set(i, node);
        return i != origPos;
    }

    private void downHeap(long i) {
        long node = this.heap.get(i);
        long j = i << 1;
        long k = j + 1L;
        if (k <= this.size && this.lessThan(this.heap.get(k), this.heap.get(j))) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap.get(j), node)) {
            this.heap.set(i, this.heap.get(j));
            i = j;
            k = (j = i << 1) + 1L;
            if (k > this.size || !this.lessThan(this.heap.get(k), this.heap.get(j))) continue;
            j = k;
        }
        this.heap.set(i, node);
    }

    private void update(long element) {
        long pos = this.findElementPosition(element);
        if (pos != 0L && !this.upHeap(pos) && pos < this.size) {
            this.downHeap(pos);
        }
    }

    private void removeCost(long element) {
        this.costKeys.clear(element);
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        return new PrimitiveIterator.OfLong(){
            int i = 1;

            @Override
            public boolean hasNext() {
                return (long)this.i <= HugeLongPriorityQueue.this.size;
            }

            @Override
            public long nextLong() {
                return HugeLongPriorityQueue.this.heap.get(this.i++);
            }
        };
    }

    public static HugeLongPriorityQueue min(long capacity) {
        return new HugeLongPriorityQueue(capacity){

            @Override
            protected boolean lessThan(long a, long b) {
                return this.costValues.get(a) < this.costValues.get(b);
            }
        };
    }

    public static HugeLongPriorityQueue max(long capacity) {
        return new HugeLongPriorityQueue(capacity){

            @Override
            protected boolean lessThan(long a, long b) {
                return this.costValues.get(a) > this.costValues.get(b);
            }
        };
    }

    public long getIth(int i) {
        return this.heap.get(i + 1);
    }
}

