/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.queue;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class BoundedLongPriorityQueue {
    private final int bound;
    private double minValue = Double.NaN;
    final long[] elements;
    final double[] priorities;
    int elementCount = 0;

    public static MemoryEstimation memoryEstimation(int capacity) {
        return MemoryEstimations.builder(BoundedLongPriorityQueue.class).fixed("elements", MemoryUsage.sizeOfLongArray((long)capacity)).fixed("priorities", MemoryUsage.sizeOfDoubleArray((long)capacity)).build();
    }

    BoundedLongPriorityQueue(int bound) {
        this.bound = bound;
        this.elements = new long[bound];
        this.priorities = new double[bound];
    }

    public abstract boolean offer(long var1, double var3);

    public abstract void forEach(Consumer var1);

    public LongStream elements() {
        return this.elementCount == 0 ? LongStream.empty() : Arrays.stream(this.elements).limit(this.elementCount);
    }

    public DoubleStream priorities() {
        return Double.isNaN(this.minValue) ? DoubleStream.empty() : Arrays.stream(this.priorities).limit(this.elementCount);
    }

    public int size() {
        return this.elementCount;
    }

    public boolean contains(long element) {
        return this.elements().anyMatch(el -> el == element);
    }

    public long elementAt(int index) {
        return this.elements[index];
    }

    public void updateElementAt(int index, long newElement) {
        this.elements[index] = newElement;
    }

    protected boolean add(long element, double priority) {
        if (this.elementCount < this.bound || Double.isNaN(this.minValue) || priority < this.minValue) {
            int idx = Arrays.binarySearch(this.priorities, 0, this.elementCount, priority);
            idx = idx < 0 ? -idx : idx + 1;
            int length = this.bound - idx;
            if (length > 0 && idx < this.bound) {
                System.arraycopy(this.priorities, idx - 1, this.priorities, idx, length);
                System.arraycopy(this.elements, idx - 1, this.elements, idx, length);
            }
            this.priorities[idx - 1] = priority;
            this.elements[idx - 1] = element;
            if (this.elementCount < this.bound) {
                ++this.elementCount;
            }
            this.minValue = this.priorities[this.elementCount - 1];
            return true;
        }
        return false;
    }

    public static BoundedLongPriorityQueue max(int bound) {
        return new BoundedLongPriorityQueue(bound){

            @Override
            public boolean offer(long element, double priority) {
                return this.add(element, -priority);
            }

            @Override
            public void forEach(Consumer consumer) {
                for (int i = 0; i < this.elementCount; ++i) {
                    consumer.accept(this.elements[i], -this.priorities[i]);
                }
            }

            @Override
            public DoubleStream priorities() {
                return super.priorities().map(d -> -d);
            }
        };
    }

    public static BoundedLongPriorityQueue min(int bound) {
        return new BoundedLongPriorityQueue(bound){

            @Override
            public boolean offer(long element, double priority) {
                return this.add(element, priority);
            }

            @Override
            public void forEach(Consumer consumer) {
                for (int i = 0; i < this.elementCount; ++i) {
                    consumer.accept(this.elements[i], this.priorities[i]);
                }
            }
        };
    }

    public static interface Consumer {
        public void accept(long var1, double var3);
    }
}

