/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.queue;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class BoundedLongLongPriorityQueue {
    private final int bound;
    private double minValue = Double.NaN;
    final long[] elements1;
    final long[] elements2;
    final double[] priorities;
    int elementCount = 0;

    public static MemoryEstimation memoryEstimation(int capacity) {
        return MemoryEstimations.builder(BoundedLongLongPriorityQueue.class).fixed("elements1", MemoryUsage.sizeOfLongArray((long)capacity)).fixed("elements2", MemoryUsage.sizeOfLongArray((long)capacity)).fixed("priorities", MemoryUsage.sizeOfDoubleArray((long)capacity)).build();
    }

    BoundedLongLongPriorityQueue(int bound) {
        this.bound = bound;
        this.elements1 = new long[bound];
        this.elements2 = new long[bound];
        this.priorities = new double[bound];
    }

    public abstract boolean offer(long var1, long var3, double var5);

    public abstract void foreach(Consumer var1);

    public int size() {
        return this.elementCount;
    }

    protected boolean add(long element1, long element2, double priority) {
        if (this.elementCount < this.bound || Double.isNaN(this.minValue) || priority < this.minValue) {
            int idx = Arrays.binarySearch(this.priorities, 0, this.elementCount, priority);
            idx = idx < 0 ? -idx : idx + 1;
            int length = this.bound - idx;
            if (length > 0 && idx < this.bound) {
                System.arraycopy(this.priorities, idx - 1, this.priorities, idx, length);
                System.arraycopy(this.elements1, idx - 1, this.elements1, idx, length);
                System.arraycopy(this.elements2, idx - 1, this.elements2, idx, length);
            }
            this.priorities[idx - 1] = priority;
            this.elements1[idx - 1] = element1;
            this.elements2[idx - 1] = element2;
            if (this.elementCount < this.bound) {
                ++this.elementCount;
            }
            this.minValue = this.priorities[this.elementCount - 1];
            return true;
        }
        return false;
    }

    public LongStream elements1() {
        return this.elementCount == 0 ? LongStream.empty() : Arrays.stream(this.elements1).limit(this.elementCount);
    }

    public LongStream elements2() {
        return this.elementCount == 0 ? LongStream.empty() : Arrays.stream(this.elements2).limit(this.elementCount);
    }

    public DoubleStream priorities() {
        return this.elementCount == 0 ? DoubleStream.empty() : Arrays.stream(this.priorities).limit(this.elementCount);
    }

    public static BoundedLongLongPriorityQueue max(int bound) {
        return new BoundedLongLongPriorityQueue(bound){

            @Override
            public boolean offer(long element1, long element2, double priority) {
                return this.add(element1, element2, -priority);
            }

            @Override
            public void foreach(Consumer consumer) {
                for (int i = 0; i < this.elementCount; ++i) {
                    consumer.accept(this.elements1[i], this.elements2[i], -this.priorities[i]);
                }
            }

            @Override
            public DoubleStream priorities() {
                return this.elementCount == 0 ? DoubleStream.empty() : Arrays.stream(this.priorities).map(d -> -d).limit(this.elementCount);
            }
        };
    }

    public static BoundedLongLongPriorityQueue min(int bound) {
        return new BoundedLongLongPriorityQueue(bound){

            @Override
            public boolean offer(long element1, long element2, double priority) {
                return this.add(element1, element2, priority);
            }

            @Override
            public void foreach(Consumer consumer) {
                for (int i = 0; i < this.elementCount; ++i) {
                    consumer.accept(this.elements1[i], this.elements2[i], this.priorities[i]);
                }
            }
        };
    }

    public static interface Consumer {
        public void accept(long var1, long var3, double var5);
    }
}

