/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress.tasks;

import java.util.Optional;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.TaskRegistry;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.tasks.LogLevel;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Status;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressLogger;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistry;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.logging.Log;

public class TaskProgressTracker
implements ProgressTracker {
    private static final long UNKNOWN_STEPS = -1L;
    private final Task baseTask;
    private final TaskRegistry taskRegistry;
    private final UserLogRegistry userLogRegistry;
    private final TaskProgressLogger taskProgressLogger;
    private final Stack<Task> nestedTasks;
    protected Optional<Task> currentTask;
    private long currentTotalSteps;
    private double progressLeftOvers;

    public TaskProgressTracker(Task baseTask, Log log, int concurrency, TaskRegistryFactory taskRegistryFactory) {
        this(baseTask, log, concurrency, new JobId(), taskRegistryFactory, EmptyUserLogRegistryFactory.INSTANCE);
    }

    public TaskProgressTracker(Task baseTask, Log log, int concurrency, JobId jobId, TaskRegistryFactory taskRegistryFactory, UserLogRegistryFactory userLogRegistryFactory) {
        this.baseTask = baseTask;
        this.taskRegistry = taskRegistryFactory.newInstance(jobId);
        this.taskProgressLogger = new TaskProgressLogger(log, baseTask, concurrency);
        this.currentTask = Optional.empty();
        this.currentTotalSteps = -1L;
        this.progressLeftOvers = 0.0;
        this.nestedTasks = new Stack();
        this.userLogRegistry = userLogRegistryFactory.newInstance();
    }

    @Override
    public void setEstimatedResourceFootprint(MemoryRange memoryRangeInBytes, int maxConcurrency) {
        this.baseTask.setEstimatedMemoryRangeInBytes(memoryRangeInBytes);
        this.baseTask.setMaxConcurrency(maxConcurrency);
    }

    @Override
    public void beginSubTask() {
        this.registerBaseTask();
        Task nextTask = this.currentTask.map(task -> {
            this.nestedTasks.add((Task)task);
            return task.nextSubtask();
        }).orElse(this.baseTask);
        nextTask.start();
        this.taskProgressLogger.logBeginSubTask(nextTask, this.parentTask());
        this.currentTask = Optional.of(nextTask);
        this.currentTotalSteps = -1L;
        this.progressLeftOvers = 0.0;
    }

    @Override
    public void beginSubTask(String expectedTaskDescription) {
        this.beginSubTask();
        this.assertSubTask(expectedTaskDescription);
    }

    @Override
    public void beginSubTask(long taskVolume) {
        this.beginSubTask();
        this.setVolume(taskVolume);
    }

    @Override
    public void setSteps(long steps) {
        if (steps <= 0L) {
            throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Total steps for task must be at least 1 but was %d", (Object[])new Object[]{steps}));
        }
        this.currentTotalSteps = steps;
    }

    @Override
    public void logSteps(long steps) {
        long volume = this.requireCurrentTask().getProgress().volume();
        double progress = (double)(steps * volume) / (double)this.currentTotalSteps + this.progressLeftOvers;
        long longProgress = (long)progress;
        this.progressLeftOvers = progress - (double)longProgress;
        this.logProgress(longProgress);
    }

    @Override
    public void beginSubTask(String expectedTaskDescription, long taskVolume) {
        this.beginSubTask();
        this.assertSubTask(expectedTaskDescription);
        this.setVolume(taskVolume);
    }

    @Override
    public void endSubTask() {
        Task currentTask = this.requireCurrentTask();
        this.taskProgressLogger.logEndSubTask(currentTask, this.parentTask());
        currentTask.finish();
        if (this.nestedTasks.isEmpty()) {
            this.currentTask = Optional.empty();
            this.release();
        } else {
            this.currentTask = Optional.of(this.nestedTasks.pop());
        }
    }

    @Override
    public void endSubTask(String expectedTaskDescription) {
        this.assertSubTask(expectedTaskDescription);
        this.endSubTask();
    }

    @Override
    public void logProgress(long value) {
        this.requireCurrentTask().logProgress(value);
        this.taskProgressLogger.logProgress(value);
    }

    @Override
    public void logProgress(long value, String messageTemplate) {
        this.requireCurrentTask().logProgress(value);
        this.taskProgressLogger.logMessage(StringFormatting.formatWithLocale((String)messageTemplate, (Object[])new Object[]{value}));
    }

    @Override
    public void setVolume(long volume) {
        this.requireCurrentTask().setVolume(volume);
        this.taskProgressLogger.reset(volume);
    }

    @Override
    public long currentVolume() {
        return this.requireCurrentTask().getProgress().volume();
    }

    @Override
    public void logMessage(LogLevel level, String message) {
        switch (level) {
            case WARNING: {
                this.userLogRegistry.addWarningToLog(this.baseTask, message);
                this.taskProgressLogger.logWarning(":: " + message);
                break;
            }
            case INFO: {
                this.taskProgressLogger.logMessage(":: " + message);
                break;
            }
            case DEBUG: {
                this.taskProgressLogger.logDebug(":: " + message);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown log level " + level);
            }
        }
    }

    @Override
    public void release() {
        this.taskRegistry.unregisterTask();
        this.validateTaskNotRunning();
    }

    @Override
    public void endSubTaskWithFailure() {
        Task currentTask = this.requireCurrentTask();
        currentTask.fail();
        this.taskProgressLogger.logEndSubTaskWithFailure(currentTask, this.parentTask());
        if (this.nestedTasks.isEmpty()) {
            this.currentTask = Optional.empty();
            this.release();
        } else {
            this.currentTask = Optional.of(this.nestedTasks.pop());
            this.endSubTaskWithFailure();
        }
    }

    @Override
    public void endSubTaskWithFailure(String expectedTaskDescription) {
        this.assertSubTask(expectedTaskDescription);
        this.endSubTaskWithFailure();
    }

    @TestOnly
    public Task currentSubTask() {
        return this.requireCurrentTask();
    }

    @Nullable
    private Task parentTask() {
        return this.nestedTasks.isEmpty() ? null : this.nestedTasks.peek();
    }

    private void registerBaseTask() {
        if (!this.taskRegistry.containsTask(this.baseTask)) {
            this.taskRegistry.registerTask(this.baseTask);
        }
    }

    private Task requireCurrentTask() {
        return this.currentTask.orElseThrow(() -> new IllegalStateException("No more running tasks"));
    }

    private void validateTaskNotRunning() {
        if (this.baseTask.status() == Status.RUNNING) {
            String message = StringFormatting.formatWithLocale((String)"Attempted to release algorithm, but task %s is still running", (Object[])new Object[]{this.baseTask.description()});
            assert (false) : message;
            this.taskProgressLogger.logWarning(message);
        }
    }

    private void assertSubTask(String subTaskSubString) {
        if (this.currentTask.isPresent()) {
            String currentTaskDescription = this.currentTask.get().description();
            assert (currentTaskDescription.contains(subTaskSubString)) : StringFormatting.formatWithLocale((String)"Expected task name to contain `%s`, but was `%s`", (Object[])new Object[]{subTaskSubString, currentTaskDescription});
        }
    }
}

