/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress.tasks;

import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.utils.BatchingProgressLogger;
import org.neo4j.gds.core.utils.ProgressLogger;
import org.neo4j.gds.core.utils.progress.tasks.IterativeTask;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskVisitor;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.logging.Log;

class TaskProgressLogger
extends BatchingProgressLogger {
    private final Task baseTask;
    private final LoggingLeafTaskVisitor loggingLeafTaskVisitor;

    TaskProgressLogger(Log log, Task baseTask, int concurrency) {
        super(log, baseTask, concurrency);
        this.baseTask = baseTask;
        this.loggingLeafTaskVisitor = new LoggingLeafTaskVisitor(this);
    }

    void logBeginSubTask(Task task, Task parentTask) {
        String taskName = this.taskDescription(task, parentTask);
        if (parentTask == null) {
            this.logStart(taskName);
        } else {
            this.startSubTask(taskName);
        }
        this.reset(task.getProgress().volume());
    }

    void logEndSubTask(Task task, Task parentTask) {
        String taskName = this.taskDescription(task, parentTask);
        this.log100OnLeafTaskFinish(task);
        if (parentTask == null) {
            this.logFinish(taskName);
        } else {
            this.finishSubTask(taskName);
        }
    }

    void logEndSubTaskWithFailure(Task task, @Nullable Task parentTask) {
        String taskName = this.taskDescription(task, parentTask);
        this.log100OnLeafTaskFinish(task);
        if (parentTask == null) {
            this.logFinishWithFailure(taskName);
        } else {
            this.logFinishSubtaskWithFailure(taskName);
        }
    }

    private String boundedIterationsTaskName(IterativeTask iterativeTask, Task task) {
        int maxIterations = iterativeTask.maxIterations();
        int currentIteration = iterativeTask.currentIteration() + 1;
        return StringFormatting.formatWithLocale((String)"%s %d of %d", (Object[])new Object[]{this.taskDescription(task), currentIteration, maxIterations});
    }

    private String unboundedIterationsTaskName(IterativeTask iterativeTask, Task task) {
        int currentIteration = iterativeTask.currentIteration() + 1;
        return StringFormatting.formatWithLocale((String)"%s %d", (Object[])new Object[]{this.taskDescription(task), currentIteration});
    }

    private String taskDescription(Task task, Task parentTask) {
        String taskName;
        if (parentTask instanceof IterativeTask) {
            IterativeTask iterativeParentTask = (IterativeTask)parentTask;
            IterativeTask.Mode iterativeTaskMode = iterativeParentTask.mode();
            switch (iterativeTaskMode) {
                case DYNAMIC: 
                case FIXED: {
                    taskName = this.boundedIterationsTaskName(iterativeParentTask, task);
                    break;
                }
                case OPEN: {
                    taskName = this.unboundedIterationsTaskName(iterativeParentTask, task);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"Enum value %s is not supported", (Object[])new Object[]{iterativeTaskMode}));
                }
            }
        } else {
            taskName = this.taskDescription(task);
        }
        return taskName;
    }

    private String taskDescription(Task nextTask) {
        return nextTask == this.baseTask ? "" : nextTask.description();
    }

    private void log100OnLeafTaskFinish(Task task) {
        task.visit(this.loggingLeafTaskVisitor);
    }

    private static final class LoggingLeafTaskVisitor
    implements TaskVisitor {
        private final ProgressLogger progressLogger;

        private LoggingLeafTaskVisitor(ProgressLogger progressLogger) {
            this.progressLogger = progressLogger;
        }

        @Override
        public void visitLeafTask(LeafTask leafTask) {
            this.progressLogger.logFinishPercentage();
        }
    }
}

