/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress.tasks;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.gds.core.utils.progress.tasks.ImmutableProgress;
import org.neo4j.gds.core.utils.progress.tasks.Progress;
import org.neo4j.gds.core.utils.progress.tasks.Status;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskVisitor;
import org.neo4j.gds.utils.StringFormatting;

public class IterativeTask
extends Task {
    private final Supplier<List<Task>> subTasksSupplier;
    private final Mode mode;
    private final int maxIterations;

    IterativeTask(String description, List<Task> subTasks, Supplier<List<Task>> subTasksSupplier, Mode mode) {
        super(description, subTasks);
        this.subTasksSupplier = subTasksSupplier;
        this.mode = mode;
        this.maxIterations = this.subTasks().size() / subTasksSupplier.get().size();
    }

    @Override
    public Progress getProgress() {
        Progress progress = super.getProgress();
        if (this.mode == Mode.OPEN && this.status() != Status.FINISHED) {
            return ImmutableProgress.of(progress.progress(), -1L);
        }
        return progress;
    }

    @Override
    protected Task nextSubTaskAfterValidation() {
        Optional<Task> maybeRunningTask = this.subTasks().stream().filter(t -> t.status() == Status.RUNNING).findFirst();
        if (maybeRunningTask.isPresent()) {
            throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Cannot move to next subtask, because subtask `%s` is still running", (Object[])new Object[]{maybeRunningTask.get().description()}));
        }
        Optional<Task> maybeNextSubtask = this.subTasks().stream().filter(t -> t.status() == Status.PENDING).findFirst();
        if (maybeNextSubtask.isPresent()) {
            return maybeNextSubtask.get();
        }
        if (this.mode == Mode.OPEN) {
            List<Task> newIterationTasks = this.subTasksSupplier.get();
            this.subTasks().addAll(newIterationTasks);
            return newIterationTasks.get(0);
        }
        throw new IllegalStateException("No more pending subtasks");
    }

    @Override
    public void finish() {
        super.finish();
        this.subTasks().forEach(t -> {
            if (t.status() == Status.PENDING) {
                t.cancel();
            }
        });
    }

    public int currentIteration() {
        return (int)this.subTasks().stream().filter(t -> t.status() == Status.FINISHED).count() / this.subTasksSupplier.get().size();
    }

    public Mode mode() {
        return this.mode;
    }

    int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public void visit(TaskVisitor taskVisitor) {
        taskVisitor.visitIterativeTask(this);
    }

    public static enum Mode {
        DYNAMIC,
        OPEN,
        FIXED;

    }
}

