/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress.tasks;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.progress.tasks.Progress;

@ParametersAreNonnullByDefault
@Generated(from="Progress", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableProgress
implements Progress {
    private final long progress;
    private final long volume;
    private volatile transient long lazyInitBitmap;
    private static final long RELATIVE_PROGRESS_LAZY_INIT_BIT = 1L;
    private transient double relativeProgress;

    private ImmutableProgress(long progress, long volume) {
        this.progress = progress;
        this.volume = volume;
    }

    @Override
    public long progress() {
        return this.progress;
    }

    @Override
    public long volume() {
        return this.volume;
    }

    public final ImmutableProgress withProgress(long value) {
        if (this.progress == value) {
            return this;
        }
        return new ImmutableProgress(value, this.volume);
    }

    public final ImmutableProgress withVolume(long value) {
        if (this.volume == value) {
            return this;
        }
        return new ImmutableProgress(this.progress, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProgress && this.equalTo((ImmutableProgress)another);
    }

    private boolean equalTo(ImmutableProgress another) {
        return this.progress == another.progress && this.volume == another.volume;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.progress);
        h += (h << 5) + Long.hashCode(this.volume);
        return h;
    }

    public String toString() {
        return "Progress{progress=" + this.progress + ", volume=" + this.volume + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double relativeProgress() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableProgress immutableProgress = this;
            synchronized (immutableProgress) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.relativeProgress = Progress.super.relativeProgress();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.relativeProgress;
    }

    public static Progress of(long progress, long volume) {
        return new ImmutableProgress(progress, volume);
    }

    public static Progress copyOf(Progress instance) {
        if (instance instanceof ImmutableProgress) {
            return (ImmutableProgress)instance;
        }
        return ImmutableProgress.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Progress", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PROGRESS = 1L;
        private static final long INIT_BIT_VOLUME = 2L;
        private long initBits = 3L;
        private long progress;
        private long volume;

        private Builder() {
        }

        public final Builder from(Progress instance) {
            Objects.requireNonNull(instance, "instance");
            this.progress(instance.progress());
            this.volume(instance.volume());
            return this;
        }

        public final Builder progress(long progress) {
            this.progress = progress;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder volume(long volume) {
            this.volume = volume;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.progress = 0L;
            this.volume = 0L;
            return this;
        }

        public Progress build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProgress(this.progress, this.volume);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("progress");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("volume");
            }
            return "Cannot build Progress, some of required attributes are not set " + attributes;
        }
    }
}

