/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress;

import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.TaskStore;
import org.neo4j.gds.core.utils.progress.tasks.Task;

public class TaskRegistry {
    private final String username;
    private final TaskStore taskStore;
    private final JobId jobId;

    @TestOnly
    public TaskRegistry(TaskRegistry taskRegistry) {
        this(taskRegistry.username, taskRegistry.taskStore);
    }

    public TaskRegistry(String username, TaskStore taskStore) {
        this.username = username;
        this.taskStore = taskStore;
        this.jobId = new JobId();
    }

    public TaskRegistry(String username, TaskStore taskStore, JobId jobId) {
        this.username = username;
        this.taskStore = taskStore;
        this.jobId = jobId;
    }

    public void registerTask(Task task) {
        this.taskStore.store(this.username, this.jobId, task);
    }

    public void unregisterTask() {
        this.taskStore.remove(this.username, this.jobId);
    }

    public boolean containsTask(Task task) {
        return this.taskStore.query(this.username, this.jobId).map(t -> t == task).orElse(false);
    }
}

