/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress;

import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.TaskRegistry;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.TaskStore;
import org.neo4j.gds.utils.StringFormatting;

public class LocalTaskRegistryFactory
implements TaskRegistryFactory {
    private final String username;
    private final TaskStore taskStore;

    LocalTaskRegistryFactory(String username, TaskStore taskStore) {
        this.username = username;
        this.taskStore = taskStore;
    }

    @Override
    public TaskRegistry newInstance(JobId jobId) {
        this.taskStore.query(this.username, jobId).ifPresent(id -> {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"There's already a job running with jobId '%s'", (Object[])new Object[]{jobId.asString()}));
        });
        return new TaskRegistry(this.username, this.taskStore, jobId);
    }
}

