/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.progress;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.core.utils.progress.LocalTaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.TaskStore;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.procedure.Context;

public class GlobalTaskStore
implements TaskStore,
ThrowingFunction<Context, TaskRegistryFactory, ProcedureException> {
    private final Map<String, Map<JobId, Task>> registeredTasks = new ConcurrentHashMap<String, Map<JobId, Task>>();

    @Override
    public void store(String username, JobId jobId, Task task) {
        this.registeredTasks.computeIfAbsent(username, __ -> new ConcurrentHashMap()).put(jobId, task);
    }

    @Override
    public void remove(String username, JobId jobId) {
        if (this.registeredTasks.containsKey(username)) {
            this.registeredTasks.get(username).remove(jobId);
        }
    }

    @Override
    @NotNull
    public Map<JobId, Task> query(String username) {
        return this.registeredTasks.getOrDefault(username, Map.of());
    }

    @Override
    public Optional<Task> query(String username, JobId jobId) {
        if (this.registeredTasks.containsKey(username)) {
            return Optional.ofNullable(this.registeredTasks.get(username).get(jobId));
        }
        return Optional.empty();
    }

    @Override
    public Stream<Task> taskStream() {
        return this.registeredTasks.values().stream().map(Map::values).flatMap(Collection::stream);
    }

    public TaskRegistryFactory apply(Context context) throws ProcedureException {
        String username = Neo4jProxy.username((AuthSubject)context.securityContext().subject());
        return new LocalTaskRegistryFactory(username, this);
    }

    @Override
    public boolean isEmpty() {
        return this.registeredTasks.values().stream().allMatch(Map::isEmpty);
    }
}

