/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.partition;

import com.carrotsearch.hppc.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.DegreePartition;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.utils.StringFormatting;

public final class PartitionUtils {
    private PartitionUtils() {
    }

    public static <TASK> List<TASK> rangePartition(int concurrency, long nodeCount, Function<Partition, TASK> taskCreator, Optional<Integer> minBatchSize) {
        long batchSize = ParallelUtil.adjustedBatchSize(nodeCount, concurrency, (long)minBatchSize.orElse(10000).intValue());
        return PartitionUtils.rangePartitionWithBatchSize(nodeCount, batchSize, taskCreator);
    }

    public static <TASK> List<TASK> rangePartitionWithBatchSize(long nodeCount, long batchSize, Function<Partition, TASK> taskCreator) {
        return PartitionUtils.tasks(nodeCount, batchSize, taskCreator);
    }

    public static List<Partition> numberAlignedPartitioning(int concurrency, long nodeCount, long alignTo) {
        return PartitionUtils.numberAlignedPartitioning(concurrency, nodeCount, alignTo, Function.identity());
    }

    public static <TASK> List<TASK> numberAlignedPartitioning(int concurrency, long nodeCount, long alignTo, Function<Partition, TASK> taskCreator) {
        return PartitionUtils.numberAlignedPartitioningWithMaxSize(concurrency, nodeCount, alignTo, Long.MAX_VALUE, taskCreator);
    }

    public static List<Partition> numberAlignedPartitioningWithMaxSize(int concurrency, long nodeCount, long alignTo, long maxPartitionSize) {
        return PartitionUtils.numberAlignedPartitioningWithMaxSize(concurrency, nodeCount, alignTo, maxPartitionSize, Function.identity());
    }

    public static <TASK> List<TASK> numberAlignedPartitioningWithMaxSize(int concurrency, long nodeCount, long alignTo, long maxPartitionSize, Function<Partition, TASK> taskCreator) {
        long adjustedBatchSize;
        if (maxPartitionSize < alignTo) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Maximum size of a partition must be at least as much as its desired alignment but got align=%d and maxPartitionSize=%d", (Object[])new Object[]{alignTo, maxPartitionSize}));
        }
        long initialBatchSize = ParallelUtil.adjustedBatchSize(nodeCount, concurrency, alignTo);
        long remainder = initialBatchSize % alignTo;
        long l = adjustedBatchSize = remainder == 0L ? initialBatchSize : initialBatchSize + (alignTo - remainder);
        if (adjustedBatchSize > maxPartitionSize) {
            long overflow = maxPartitionSize % alignTo;
            adjustedBatchSize = maxPartitionSize - overflow;
        }
        return PartitionUtils.tasks(nodeCount, adjustedBatchSize, taskCreator);
    }

    public static <TASK> List<TASK> degreePartition(Graph graph, int concurrency, Function<DegreePartition, TASK> taskCreator, Optional<Integer> minBatchSize) {
        long batchSize = Math.max((long)minBatchSize.orElse(10000).intValue(), BitUtil.ceilDiv((long)graph.relationshipCount(), (long)concurrency));
        return PartitionUtils.degreePartitionWithBatchSize(graph.nodeIterator(), graph::degree, batchSize, taskCreator);
    }

    public static <TASK> List<TASK> degreePartitionWithBatchSize(Graph graph, long batchSize, Function<DegreePartition, TASK> taskCreator) {
        return PartitionUtils.degreePartitionWithBatchSize(graph.nodeIterator(), graph::degree, batchSize, taskCreator);
    }

    public static <TASK> List<TASK> degreePartitionWithBatchSize(PrimitiveIterator.OfLong nodes, DegreeFunction degrees, long batchSize, Function<DegreePartition, TASK> taskCreator) {
        ArrayList<TASK> result = new ArrayList<TASK>();
        long start = 0L;
        while (nodes.hasNext()) {
            long partitionSize;
            assert (batchSize > 0L);
            long nodeId = 0L;
            for (partitionSize = 0L; nodes.hasNext() && partitionSize <= batchSize && nodeId - start < 0x3FFFFFEFL; partitionSize += (long)degrees.degree(nodeId)) {
                nodeId = nodes.nextLong();
            }
            long end = nodeId + 1L;
            result.add(taskCreator.apply(DegreePartition.of(start, end - start, partitionSize)));
            start = end;
        }
        return result;
    }

    private static <TASK> List<TASK> tasks(long nodeCount, long batchSize, Function<Partition, TASK> taskCreator) {
        int expectedCapacity = Math.toIntExact(BitUtil.ceilDiv((long)nodeCount, (long)batchSize));
        ArrayList<TASK> result = new ArrayList<TASK>(expectedCapacity);
        for (long i = 0L; i < nodeCount; i += batchSize) {
            result.add(taskCreator.apply(Partition.of(i, PartitionUtils.actualBatchSize(i, batchSize, nodeCount))));
        }
        return result;
    }

    private static long actualBatchSize(long startNode, long batchSize, long nodeCount) {
        return startNode + batchSize < nodeCount ? batchSize : nodeCount - startNode;
    }

    public static List<Long> rangePartitionActualBatchSizes(int concurrency, long nodeCount, Optional<Integer> minBatchSize) {
        long batchSize = ParallelUtil.adjustedBatchSize(nodeCount, concurrency, (long)minBatchSize.orElse(10000).intValue());
        int expectedCapacity = Math.toIntExact(BitUtil.ceilDiv((long)nodeCount, (long)batchSize));
        ArrayList<Long> batchSizes = new ArrayList<Long>(expectedCapacity);
        for (long i = 0L; i < nodeCount; i += batchSize) {
            batchSizes.add(PartitionUtils.actualBatchSize(i, batchSize, nodeCount));
        }
        return batchSizes;
    }

    public static <TASK> Iterator<TASK> blockAlignedPartitioning(HugeLongArray sortedIds, int blockShift, Function<Partition, TASK> taskCreator) {
        return new BlockAlignedPartitionIterator<TASK>(sortedIds, blockShift, taskCreator);
    }

    private static class BlockAlignedPartitionIterator<TASK>
    extends AbstractIterator<TASK> {
        private final HugeCursor<long[]> cursor;
        private final long size;
        private final int blockShift;
        private final Function<Partition, TASK> taskCreator;
        private int prevBlockId;
        private long blockStart;
        private boolean done;
        private int lastIndex;

        BlockAlignedPartitionIterator(HugeLongArray sortedIds, int blockShift, Function<Partition, TASK> taskCreator) {
            this.size = sortedIds.size();
            this.blockShift = blockShift;
            this.taskCreator = taskCreator;
            this.cursor = sortedIds.initCursor(sortedIds.newCursor());
            this.prevBlockId = 0;
            this.blockStart = 0L;
            this.done = false;
            this.lastIndex = Integer.MAX_VALUE;
        }

        protected TASK fetch() {
            if (this.done) {
                return (TASK)this.done();
            }
            long base = this.cursor.base;
            int limit = this.cursor.limit;
            long[] array = (long[])this.cursor.array;
            int prevBlockId = this.prevBlockId;
            int blockShift = this.blockShift;
            for (int i = this.lastIndex; i < limit; ++i) {
                long originalId = array[i];
                int blockId = (int)(originalId >>> blockShift);
                if (blockId == prevBlockId) continue;
                long internalId = base + (long)i;
                prevBlockId = blockId;
                if (internalId <= 0L) continue;
                Partition partition = Partition.of(this.blockStart, internalId - this.blockStart);
                this.blockStart = internalId;
                this.prevBlockId = prevBlockId;
                this.lastIndex = i;
                return this.taskCreator.apply(partition);
            }
            if (this.cursor.next()) {
                this.prevBlockId = prevBlockId;
                this.lastIndex = this.cursor.offset;
                return this.fetch();
            }
            Partition partition = Partition.of(this.blockStart, this.size - this.blockStart);
            this.done = true;
            return this.taskCreator.apply(partition);
        }
    }

    @FunctionalInterface
    public static interface DegreeFunction {
        public int degree(long var1);
    }
}

