/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.partition;

import java.util.Objects;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;

public class Partition {
    private final long startNode;
    private final long nodeCount;
    static final int MAX_NODE_COUNT = 0x3FFFFFEF;

    public Partition(long startNode, long nodeCount) {
        this.startNode = startNode;
        this.nodeCount = nodeCount;
    }

    public long startNode() {
        return this.startNode;
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public void consume(LongConsumer consumer) {
        long startNode = this.startNode();
        long endNode = startNode + this.nodeCount();
        for (long id = startNode; id < endNode; ++id) {
            consumer.accept(id);
        }
    }

    public static Partition of(long startNode, long nodeCount) {
        return new Partition(startNode, nodeCount);
    }

    public LongStream stream() {
        long start = this.startNode();
        return LongStream.range(start, start + this.nodeCount());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return this.startNode == partition.startNode && this.nodeCount == partition.nodeCount;
    }

    public String toString() {
        return "Partition{start:" + this.startNode + ", length:" + this.nodeCount + "}";
    }

    public int hashCode() {
        return Objects.hash(this.startNode, this.nodeCount);
    }
}

