/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.partition;

import java.util.Objects;
import org.neo4j.gds.core.utils.partition.Partition;

public class DegreePartition
extends Partition {
    private final long totalDegree;

    public DegreePartition(long startNode, long nodeCount, long totalDegree) {
        super(startNode, nodeCount);
        this.totalDegree = totalDegree;
    }

    public long totalDegree() {
        return this.totalDegree;
    }

    public static DegreePartition of(long startNode, long nodeCount, long totalDegree) {
        return new DegreePartition(startNode, nodeCount, totalDegree);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DegreePartition that = (DegreePartition)o;
        return this.totalDegree == that.totalDegree;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.totalDegree);
    }
}

