/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged.dss;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.LongPageCreator;
import org.neo4j.gds.core.utils.paged.dss.DisjointSetStruct;

public final class HugeAtomicDisjointSetStruct
implements DisjointSetStruct {
    private static final int NO_SUCH_SEED_VALUE = 0;
    private final HugeAtomicLongArray parent;
    private final HugeAtomicLongArray communities;
    private final AtomicLong maxCommunityId;

    public static MemoryEstimation memoryEstimation(boolean incremental) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(HugeAtomicDisjointSetStruct.class).perNode("data", HugeAtomicLongArray::memoryEstimation);
        if (incremental) {
            builder.perNode("seeding information", HugeAtomicLongArray::memoryEstimation);
        }
        return builder.build();
    }

    public HugeAtomicDisjointSetStruct(long capacity, int concurrency) {
        this.parent = HugeAtomicLongArray.newArray(capacity, LongPageCreator.identity(concurrency));
        this.communities = null;
        this.maxCommunityId = null;
    }

    public HugeAtomicDisjointSetStruct(long capacity, NodePropertyValues communityMapping, int concurrency) {
        this.parent = HugeAtomicLongArray.newArray(capacity, LongPageCreator.identity(concurrency));
        this.communities = HugeAtomicLongArray.newArray(capacity, LongPageCreator.of(concurrency, nodeId -> {
            long seedCommunity = communityMapping.longValue(nodeId);
            return seedCommunity < 0L ? -1L : seedCommunity;
        }));
        this.maxCommunityId = new AtomicLong(communityMapping.getMaxLongPropertyValue().orElse(0L));
    }

    private long parent(long id) {
        return this.parent.get(id);
    }

    private long find(long id) {
        long parent;
        while (id != (parent = this.parent(id))) {
            long grandParent = this.parent(parent);
            if (parent != grandParent) {
                this.parent.compareAndSet(id, parent, grandParent);
            }
            id = grandParent;
        }
        return id;
    }

    @Override
    public long setIdOf(long nodeId) {
        long newSetId;
        long providedSetId;
        long setId = this.find(nodeId);
        if (this.communities == null) {
            return setId;
        }
        do {
            if ((providedSetId = this.communities.get(setId)) < 0L) continue;
            return providedSetId;
        } while (!this.communities.compareAndSet(setId, providedSetId, newSetId = this.maxCommunityId.incrementAndGet()));
        return newSetId;
    }

    @Override
    public boolean sameSet(long id1, long id2) {
        do {
            if ((id1 = this.find(id1)) != (id2 = this.find(id2))) continue;
            return true;
        } while (this.parent(id1) != id1);
        return false;
    }

    @Override
    public void union(long id1, long id2) {
        long newEntry;
        long oldEntry;
        do {
            if ((id1 = this.find(id1)) == (id2 = this.find(id2))) {
                return;
            }
            if (this.setIdOf(id1) >= this.setIdOf(id2)) continue;
            long tmp = id2;
            id2 = id1;
            id1 = tmp;
        } while (!this.parent.compareAndSet(id1, oldEntry = id1, newEntry = id2));
    }

    @Override
    public long size() {
        return this.parent.size();
    }
}

