/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import org.neo4j.gds.core.utils.paged.PageAllocator;
import org.neo4j.gds.core.utils.paged.PagedDataStructure;

public class PagedLongStack
extends PagedDataStructure<long[]> {
    private static final PageAllocator.Factory<long[]> ALLOCATOR_FACTORY = PageAllocator.ofArray(long[].class);
    private long size;
    private int pageIndex;
    private int pageTop;
    private int pageLimit;
    private long[] currentPage;

    public PagedLongStack(long initialSize) {
        this(Math.max(1L, initialSize), ALLOCATOR_FACTORY.newAllocator());
    }

    private PagedLongStack(long initialSize, PageAllocator<long[]> allocator) {
        super(initialSize, allocator);
        this.clear();
    }

    public void clear() {
        this.size = 0L;
        this.pageTop = -1;
        this.pageIndex = 0;
        this.currentPage = ((long[][])this.pages)[0];
        this.pageLimit = this.currentPage.length;
    }

    public void push(long value) {
        int pageTop;
        if ((pageTop = ++this.pageTop) >= this.pageLimit) {
            pageTop = this.nextPage();
        }
        ++this.size;
        this.currentPage[pageTop] = value;
    }

    public long pop() {
        int pageTop = this.pageTop;
        if (pageTop < 0) {
            pageTop = this.previousPage();
        }
        --this.pageTop;
        --this.size;
        return this.currentPage[pageTop];
    }

    public long peek() {
        int pageTop = this.pageTop;
        if (pageTop < 0) {
            int pageIndex = this.pageIndex;
            this.pageLimit = ((long[][])this.pages)[--pageIndex].length;
            return ((long[][])this.pages)[pageIndex][this.pageLimit - 1];
        }
        return this.currentPage[pageTop];
    }

    public boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long release() {
        long released = super.release();
        this.size = 0L;
        this.pageTop = 0;
        this.pageIndex = 0;
        this.pageLimit = 0;
        this.currentPage = null;
        return released;
    }

    private int nextPage() {
        int pageIndex;
        if ((pageIndex = ++this.pageIndex) >= ((long[][])this.pages).length) {
            this.grow(this.capacityFor(pageIndex + 1));
        }
        this.currentPage = ((long[][])this.pages)[pageIndex];
        this.pageLimit = this.currentPage.length;
        this.pageTop = 0;
        return 0;
    }

    private int previousPage() {
        int pageIndex = this.pageIndex;
        this.currentPage = ((long[][])this.pages)[--pageIndex];
        this.pageLimit = this.currentPage.length;
        this.pageIndex = pageIndex;
        this.pageTop = this.pageLimit - 1;
        return this.pageTop;
    }
}

