/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.core.utils.paged.PaddedAtomicLong;
import org.neo4j.gds.core.utils.paged.PageAllocator;

public class PagedDataStructure<T> {
    final int pageSize;
    final int pageShift;
    final int pageMask;
    private final long maxSupportedSize;
    volatile T[] pages;
    private final AtomicLong size = new PaddedAtomicLong();
    private final AtomicLong capacity = new PaddedAtomicLong();
    private final ReentrantLock growLock = new ReentrantLock(true);
    private final PageAllocator<T> allocator;

    PagedDataStructure(long size, PageAllocator<T> allocator) {
        this.pageSize = allocator.pageSize();
        this.pageShift = Integer.numberOfTrailingZeros(this.pageSize);
        this.pageMask = this.pageSize - 1;
        int maxIndexShift = 31 + this.pageShift;
        this.maxSupportedSize = 1L << maxIndexShift;
        assert (size <= this.maxSupportedSize);
        this.size.set(size);
        this.allocator = allocator;
        this.pages = allocator.emptyPages();
        this.setPages(this.numPages(size));
    }

    public long size() {
        return this.size.get();
    }

    public final long capacity() {
        return this.capacity.get();
    }

    public long release() {
        this.size.set(0L);
        long freed = this.allocator.estimateMemoryUsage(this.capacity.getAndSet(0L));
        this.pages = null;
        return freed;
    }

    protected int numPages(long capacity) {
        return PageUtil.numPagesFor((long)capacity, (int)this.pageShift, (long)this.pageMask);
    }

    final long capacityFor(int numPages) {
        return (long)numPages << this.pageShift;
    }

    final int pageIndex(long index) {
        return (int)(index >>> this.pageShift);
    }

    final int indexInPage(long index) {
        return (int)(index & (long)this.pageMask);
    }

    final void grow(long newSize) {
        this.grow(newSize, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void grow(long newSize, int skipPage) {
        assert (newSize <= this.maxSupportedSize);
        long cap = this.capacity.get();
        if (cap >= newSize) {
            this.growSize(newSize);
            return;
        }
        this.growLock.lock();
        try {
            cap = this.capacity.get();
            if (cap >= newSize) {
                this.growSize(newSize);
                return;
            }
            this.setPages(this.numPages(newSize), this.pages.length, skipPage);
            this.growSize(newSize);
        }
        finally {
            this.growLock.unlock();
        }
    }

    private void growSize(long newSize) {
        long size;
        while ((size = this.size.get()) < newSize && !this.size.compareAndSet(size, newSize)) {
        }
    }

    private void setPages(int numPages) {
        if (numPages > 0) {
            this.setPages(numPages, 0, -1);
        }
    }

    private void setPages(int numPages, int currentNumPages, int skipPage) {
        T[] pages = Arrays.copyOf(this.pages, numPages);
        for (int i = currentNumPages; i < numPages; ++i) {
            if (i == skipPage) continue;
            pages[i] = this.allocateNewPage();
        }
        this.pages = pages;
        this.capacity.set(this.capacityFor(numPages));
    }

    T allocateNewPage() {
        return this.allocator.newPage();
    }
}

