/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.lang.reflect.Array;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class PageAllocator<T> {
    public abstract T newPage();

    public abstract int pageSize();

    public abstract T[] emptyPages();

    public abstract long bytesPerPage();

    public final long estimateMemoryUsage(long size) {
        long numPages = PageUtil.numPagesFor((long)size, (int)this.pageSize());
        return numPages * this.bytesPerPage();
    }

    public static <T> Factory<T> of(int pageSize, long bytesPerPage, PageFactory<T> newPage, T[] emptyPages) {
        return new Factory<T>(pageSize, bytesPerPage, newPage, emptyPages);
    }

    public static <T> Factory<T> ofArray(Class<T> arrayClass) {
        Class<?> componentType = arrayClass.getComponentType();
        assert (componentType != null && componentType.isPrimitive());
        long bytesPerElement = MemoryUsage.sizeOfInstance(componentType);
        int pageSize = PageUtil.pageSizeFor((int)32768, (int)((int)bytesPerElement));
        long bytesPerPage = MemoryUsage.sizeOfArray((long)pageSize, (long)bytesPerElement);
        Object[] emptyPages = (Object[])Array.newInstance(componentType, 0, 0);
        PageFactory<Object> newPage = () -> Array.newInstance(componentType, pageSize);
        return PageAllocator.of(pageSize, bytesPerPage, newPage, emptyPages);
    }

    private static final class DirectAllocator<T>
    extends PageAllocator<T> {
        private final PageFactory<T> newPage;
        private final T[] emptyPages;
        private final int pageSize;
        private final long bytesPerPage;

        private DirectAllocator(PageFactory<T> newPage, T[] emptyPages, int pageSize, long bytesPerPage) {
            assert (BitUtil.isPowerOfTwo((int)pageSize));
            this.emptyPages = emptyPages;
            this.newPage = newPage;
            this.pageSize = pageSize;
            this.bytesPerPage = bytesPerPage;
        }

        @Override
        public T newPage() {
            return this.newPage.newPage();
        }

        @Override
        public int pageSize() {
            return this.pageSize;
        }

        @Override
        public long bytesPerPage() {
            return this.bytesPerPage;
        }

        @Override
        public T[] emptyPages() {
            return this.emptyPages;
        }
    }

    @FunctionalInterface
    public static interface PageFactory<T> {
        public T newPage();
    }

    public static final class Factory<T> {
        private final int pageSize;
        private final long bytesPerPage;
        private final PageFactory<T> newPage;
        private final T[] emptyPages;

        private Factory(int pageSize, long bytesPerPage, PageFactory<T> newPage, T[] emptyPages) {
            this.pageSize = pageSize;
            this.bytesPerPage = bytesPerPage;
            this.newPage = newPage;
            this.emptyPages = emptyPages;
        }

        PageAllocator<T> newAllocator() {
            return new DirectAllocator<T>(this.newPage, this.emptyPages, this.pageSize, this.bytesPerPage);
        }
    }
}

