/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.function.LongUnaryOperator;
import java.util.stream.IntStream;
import org.neo4j.gds.core.concurrency.ParallelUtil;

public final class LongPageCreator {
    private final int concurrency;
    private final LongUnaryOperator gen;

    private LongPageCreator(int concurrency, LongUnaryOperator gen) {
        this.concurrency = concurrency;
        this.gen = gen;
    }

    public void fill(long[][] pages, int lastPageSize) {
        int lastPageIndex = pages.length - 1;
        ParallelUtil.parallelStreamConsume(IntStream.range(0, lastPageIndex), this.concurrency, stream -> stream.forEach(pageIndex -> this.createAndFillPage(pages, pageIndex, 16384)));
        this.createAndFillPage(pages, lastPageIndex, lastPageSize);
    }

    public void fillPage(long[] page, long base) {
        if (this.gen != null) {
            for (int i = 0; i < page.length; ++i) {
                page[i] = this.gen.applyAsLong((long)i + base);
            }
        }
    }

    private void createAndFillPage(long[][] pages, int pageIndex, int pageSize) {
        long[] page = new long[pageSize];
        pages[pageIndex] = page;
        long base = (long)pageIndex << 14;
        this.fillPage(page, base);
    }

    public static LongPageCreator of(int concurrency, LongUnaryOperator gen) {
        return new LongPageCreator(concurrency, gen);
    }

    public static LongPageCreator identity(int concurrency) {
        return new LongPageCreator(concurrency, i -> i);
    }

    public static LongPageCreator passThrough(int concurrency) {
        return new LongPageCreator(concurrency, null);
    }
}

