/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.function.ToDoubleFunction;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;

public final class HugeSerialObjectMergeSort {
    private HugeSerialObjectMergeSort() {
    }

    public static <T> void sort(Class<T> componentClass, HugeObjectArray<T> array, ToDoubleFunction<T> toSortValue) {
        HugeObjectArray<T> temp = HugeObjectArray.newArray(componentClass, array.size());
        HugeSerialObjectMergeSort.sort(array, array.size(), toSortValue, temp);
    }

    public static <T> void sort(HugeObjectArray<T> array, long size, ToDoubleFunction<T> toSortValue, HugeObjectArray<T> temp) {
        block0: for (long tempSize = 1L; tempSize < size; tempSize *= 2L) {
            for (long i = 0L; i < size; i += 2L * tempSize) {
                long leftStart = i;
                long leftEnd = i + tempSize - 1L;
                long rightStart = i + tempSize;
                long rightEnd = i + 2L * tempSize - 1L;
                if (rightStart >= size) continue block0;
                if (rightEnd >= size) {
                    rightEnd = size - 1L;
                }
                HugeSerialObjectMergeSort.merge(array, temp, toSortValue, leftStart, leftEnd, rightStart, rightEnd);
                for (long j = 0L; j < rightEnd - leftStart + 1L; ++j) {
                    array.set(i + j, temp.get(j));
                }
            }
        }
    }

    private static <T> void merge(HugeObjectArray<T> array, HugeObjectArray<T> temp, ToDoubleFunction<T> toSortValue, long leftStart, long leftEnd, long rightStart, long rightEnd) {
        long idx = 0L;
        while (leftStart <= leftEnd && rightStart <= rightEnd) {
            T lsIdx = array.get(leftStart);
            T rsIdx = array.get(rightStart);
            if (Double.compare(toSortValue.applyAsDouble(lsIdx), toSortValue.applyAsDouble(rsIdx)) <= 0) {
                temp.set(idx++, lsIdx);
                ++leftStart;
                continue;
            }
            temp.set(idx++, rsIdx);
            ++rightStart;
        }
        while (leftStart <= leftEnd) {
            temp.set(idx++, array.get(leftStart++));
        }
        while (rightStart <= rightEnd) {
            temp.set(idx++, array.get(rightStart++));
        }
    }
}

