/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.function.LongToDoubleFunction;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public final class HugeSerialIndirectMergeSort {
    private HugeSerialIndirectMergeSort() {
    }

    public static void sort(HugeLongArray array, LongToDoubleFunction toSortValue) {
        HugeLongArray temp = HugeLongArray.newArray(array.size());
        HugeSerialIndirectMergeSort.sort(array, array.size(), toSortValue, temp);
    }

    public static void sort(HugeLongArray array, long size, LongToDoubleFunction toSortValue, HugeLongArray temp) {
        block0: for (long tempSize = 1L; tempSize < size; tempSize *= 2L) {
            for (long i = 0L; i < size; i += 2L * tempSize) {
                long leftStart = i;
                long leftEnd = i + tempSize - 1L;
                long rightStart = i + tempSize;
                long rightEnd = i + 2L * tempSize - 1L;
                if (rightStart >= size) continue block0;
                if (rightEnd >= size) {
                    rightEnd = size - 1L;
                }
                HugeSerialIndirectMergeSort.merge(array, temp, toSortValue, leftStart, leftEnd, rightStart, rightEnd);
                for (long j = 0L; j < rightEnd - leftStart + 1L; ++j) {
                    array.set(i + j, temp.get(j));
                }
            }
        }
    }

    private static void merge(HugeLongArray array, HugeLongArray temp, LongToDoubleFunction toSortValue, long leftStart, long leftEnd, long rightStart, long rightEnd) {
        long idx = 0L;
        while (leftStart <= leftEnd && rightStart <= rightEnd) {
            long lsIdx = array.get(leftStart);
            long rsIdx = array.get(rightStart);
            if (Double.compare(toSortValue.applyAsDouble(lsIdx), toSortValue.applyAsDouble(rsIdx)) <= 0) {
                temp.set(idx++, lsIdx);
                ++leftStart;
                continue;
            }
            temp.set(idx++, rsIdx);
            ++rightStart;
        }
        while (leftStart <= leftEnd) {
            temp.set(idx++, array.get(leftStart++));
        }
        while (rightStart <= rightEnd) {
            temp.set(idx++, array.get(rightStart++));
        }
    }
}

