/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import org.neo4j.gds.api.properties.nodes.DoubleArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.FloatArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.LongArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.ArrayUtil;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeArray;
import org.neo4j.gds.core.utils.paged.HugeArrays;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class HugeObjectArray<T>
extends HugeArray<T[], T, HugeObjectArray<T>> {
    public abstract T get(long var1);

    public abstract void set(long var1, T var3);

    public abstract T putIfAbsent(long var1, Supplier<T> var3);

    public abstract void setAll(LongFunction<T> var1);

    public abstract void fill(T var1);

    @Override
    public abstract long size();

    @Override
    public abstract long sizeOf();

    @Override
    public abstract long release();

    @Override
    public abstract HugeCursor<T[]> newCursor();

    @Override
    public abstract void copyTo(HugeObjectArray<T> var1, long var2);

    @Override
    public abstract HugeObjectArray<T> copyOf(long var1);

    @Override
    final T boxedGet(long index) {
        return this.get(index);
    }

    @Override
    final void boxedSet(long index, T value) {
        this.set(index, value);
    }

    @Override
    final void boxedSetAll(LongFunction<T> gen) {
        this.setAll(gen);
    }

    @Override
    final void boxedFill(T value) {
        this.fill(value);
    }

    @Override
    public abstract T[] toArray();

    @Override
    public NodePropertyValues asNodeProperties() {
        Class<T> cls = this.elementClass();
        if (cls == float[].class) {
            return new FloatArrayNodePropertyValues(){

                @Override
                public float[] floatArrayValue(long nodeId) {
                    return (float[])HugeObjectArray.this.get(nodeId);
                }

                @Override
                public long size() {
                    return HugeObjectArray.this.size();
                }
            };
        }
        if (cls == double[].class) {
            return new DoubleArrayNodePropertyValues(){

                @Override
                public double[] doubleArrayValue(long nodeId) {
                    return (double[])HugeObjectArray.this.get(nodeId);
                }

                @Override
                public long size() {
                    return HugeObjectArray.this.size();
                }
            };
        }
        if (cls == long[].class) {
            return new LongArrayNodePropertyValues(){

                @Override
                public long[] longArrayValue(long nodeId) {
                    return (long[])HugeObjectArray.this.get(nodeId);
                }

                @Override
                public long size() {
                    return HugeObjectArray.this.size();
                }
            };
        }
        throw new UnsupportedOperationException("This HugeObjectArray can not be converted to node properties.");
    }

    abstract Class<T> elementClass();

    public static <T> HugeObjectArray<T> newArray(Class<T> componentClass, long size) {
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return SingleHugeObjectArray.of(componentClass, size);
        }
        return PagedHugeObjectArray.of(componentClass, size);
    }

    @SafeVarargs
    public static <T> HugeObjectArray<T> of(T ... values) {
        return new SingleHugeObjectArray<T>(values.length, values);
    }

    static <T> HugeObjectArray<T> newPagedArray(Class<T> componentClass, long size) {
        return PagedHugeObjectArray.of(componentClass, size);
    }

    static <T> HugeObjectArray<T> newSingleArray(Class<T> componentClass, int size) {
        return SingleHugeObjectArray.of(componentClass, size);
    }

    public static long memoryEstimation(long arraySize, long objectSize) {
        long sizeOfInstance = arraySize <= (long)ArrayUtil.MAX_ARRAY_LENGTH ? MemoryUsage.sizeOfInstance(SingleHugeObjectArray.class) : MemoryUsage.sizeOfInstance(PagedHugeObjectArray.class);
        int numPages = HugeArrays.numberOfPages(arraySize);
        long outArrayMemoryUsage = MemoryUsage.sizeOfObjectArray((long)numPages);
        long memoryUsagePerPage = MemoryUsage.sizeOfObjectArray((long)16384L) + 16384L * objectSize;
        long pageMemoryUsage = (long)(numPages - 1) * memoryUsagePerPage;
        int lastPageSize = HugeArrays.exclusiveIndexOfPage(arraySize);
        long lastPageMemoryUsage = MemoryUsage.sizeOfObjectArray((long)lastPageSize) + (long)lastPageSize * objectSize;
        return sizeOfInstance + outArrayMemoryUsage + pageMemoryUsage + lastPageMemoryUsage;
    }

    public static MemoryEstimation memoryEstimation(MemoryEstimation objectEstimation) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder();
        builder.perNode("instance", nodeCount -> {
            if (nodeCount <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
                return MemoryUsage.sizeOfInstance(SingleHugeObjectArray.class);
            }
            return MemoryUsage.sizeOfInstance(PagedHugeObjectArray.class);
        });
        builder.perNode("data", objectEstimation);
        builder.perNode("pages", nodeCount -> {
            if (nodeCount <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
                return MemoryUsage.sizeOfObjectArray((long)nodeCount);
            }
            int numPages = HugeArrays.numberOfPages(nodeCount);
            return MemoryUsage.sizeOfObjectArray((long)numPages) + (long)numPages * MemoryUsage.sizeOfObjectArray((long)16384L);
        });
        return builder.build();
    }

    public static MemoryEstimation memoryEstimation(long objectEstimation) {
        return HugeObjectArray.memoryEstimation(MemoryEstimations.of((String)"instance", (dimensions, concurrency) -> MemoryRange.of((long)objectEstimation)));
    }

    private static final class PagedHugeObjectArray<T>
    extends HugeObjectArray<T> {
        private final long size;
        private T[][] pages;
        private final long memoryUsed;

        private static <T> HugeObjectArray<T> of(Class<T> componentClass, long size) {
            int numPages = HugeArrays.numberOfPages(size);
            Object[][] pages = (Object[][])Array.newInstance(componentClass, numPages, 16384);
            long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numPages);
            long pageBytes = MemoryUsage.sizeOfObjectArray((long)16384L);
            memoryUsed += (long)(numPages - 1) * pageBytes;
            int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
            pages[numPages - 1] = (Object[])Array.newInstance(componentClass, lastPageSize);
            return new PagedHugeObjectArray<Object>(size, pages, memoryUsed += MemoryUsage.sizeOfObjectArray((long)lastPageSize));
        }

        private PagedHugeObjectArray(long size, T[][] pages, long memoryUsed) {
            this.size = size;
            this.pages = pages;
            this.memoryUsed = memoryUsed;
        }

        @Override
        public T get(long index) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return this.pages[pageIndex][indexInPage];
        }

        @Override
        public void set(long index, T value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            this.pages[pageIndex][indexInPage] = value;
        }

        @Override
        public T putIfAbsent(long index, Supplier<T> supplier) {
            int indexInPage;
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            T[] page = this.pages[pageIndex];
            T value = page[indexInPage = HugeArrays.indexInPage(index)];
            if (value == null && (value = supplier.get()) != null) {
                page[indexInPage] = value;
            }
            return value;
        }

        @Override
        public void setAll(LongFunction<T> gen) {
            for (int i = 0; i < this.pages.length; ++i) {
                long t = (long)i << 14;
                Arrays.setAll(this.pages[i], j -> gen.apply(t + (long)j));
            }
        }

        @Override
        public void fill(T value) {
            for (Object[] objectArray : this.pages) {
                Arrays.fill(objectArray, value);
            }
        }

        @Override
        public void copyTo(HugeObjectArray<T> dest, long length) {
            if (length > this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeObjectArray) {
                T[] page;
                int toCopy;
                SingleHugeObjectArray dst = (SingleHugeObjectArray)dest;
                int start = 0;
                int remaining = (int)length;
                T[][] TArray = this.pages;
                int n = TArray.length;
                for (int i = 0; i < n && (toCopy = Math.min(remaining, (page = TArray[i]).length)) != 0; ++i) {
                    System.arraycopy(page, 0, dst.page, start, toCopy);
                    start += toCopy;
                    remaining -= toCopy;
                }
                Arrays.fill(dst.page, start, dst.size, null);
            } else if (dest instanceof PagedHugeObjectArray) {
                int i;
                PagedHugeObjectArray dst = (PagedHugeObjectArray)dest;
                int pageLen = Math.min(this.pages.length, dst.pages.length);
                int lastPage = pageLen - 1;
                long remaining = length;
                for (i = 0; i < lastPage; ++i) {
                    T[] page = this.pages[i];
                    T[] dstPage = dst.pages[i];
                    System.arraycopy(page, 0, dstPage, 0, page.length);
                    remaining -= (long)page.length;
                }
                if (remaining > 0L) {
                    System.arraycopy(this.pages[lastPage], 0, dst.pages[lastPage], 0, (int)remaining);
                    Arrays.fill(dst.pages[lastPage], (int)remaining, dst.pages[lastPage].length, null);
                }
                for (i = pageLen; i < dst.pages.length; ++i) {
                    Arrays.fill(dst.pages[i], null);
                }
            }
        }

        @Override
        public HugeObjectArray<T> copyOf(long newLength) {
            Class<?> tCls = this.pages.getClass().getComponentType().getComponentType();
            HugeObjectArray<?> copy = HugeObjectArray.newArray(tCls, newLength);
            this.copyTo(copy, newLength);
            return copy;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return this.memoryUsed;
        }

        @Override
        public long release() {
            if (this.pages != null) {
                this.pages = null;
                return this.memoryUsed;
            }
            return 0L;
        }

        @Override
        public HugeCursor<T[]> newCursor() {
            return new HugeCursor.PagedCursor<T[]>(this.size, (Array[])this.pages);
        }

        @Override
        public T[] toArray() {
            return (Object[])this.dumpToArray(this.pages.getClass().getComponentType());
        }

        @Override
        Class<T> elementClass() {
            return this.pages.getClass().getComponentType().getComponentType();
        }
    }

    private static final class SingleHugeObjectArray<T>
    extends HugeObjectArray<T> {
        private final int size;
        private T[] page;

        private static <T> HugeObjectArray<T> of(Class<T> componentClass, long size) {
            assert (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH);
            int intSize = (int)size;
            Object[] page = (Object[])Array.newInstance(componentClass, intSize);
            return new SingleHugeObjectArray<Object>(intSize, page);
        }

        private SingleHugeObjectArray(int size, T[] page) {
            this.size = size;
            this.page = page;
        }

        @Override
        public T get(long index) {
            assert (index < (long)this.size);
            return this.page[(int)index];
        }

        @Override
        public void set(long index, T value) {
            assert (index < (long)this.size);
            this.page[(int)index] = value;
        }

        @Override
        public T putIfAbsent(long index, Supplier<T> supplier) {
            assert (index < (long)this.size);
            T value = this.page[(int)index];
            if (value == null && (value = supplier.get()) != null) {
                this.page[(int)index] = value;
            }
            return value;
        }

        @Override
        public void setAll(LongFunction<T> gen) {
            Arrays.setAll(this.page, gen::apply);
        }

        @Override
        public void fill(T value) {
            Arrays.fill(this.page, value);
        }

        @Override
        public void copyTo(HugeObjectArray<T> dest, long length) {
            if (length > (long)this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeObjectArray) {
                SingleHugeObjectArray dst = (SingleHugeObjectArray)dest;
                System.arraycopy(this.page, 0, dst.page, 0, (int)length);
                Arrays.fill(dst.page, (int)length, dst.size, null);
            } else if (dest instanceof PagedHugeObjectArray) {
                PagedHugeObjectArray dst = (PagedHugeObjectArray)dest;
                int start = 0;
                int remaining = (int)length;
                for (Object[] objectArray : dst.pages) {
                    int toCopy = Math.min(remaining, objectArray.length);
                    if (toCopy == 0) {
                        Arrays.fill(this.page, null);
                        continue;
                    }
                    System.arraycopy(this.page, start, objectArray, 0, toCopy);
                    if (toCopy < objectArray.length) {
                        Arrays.fill(objectArray, toCopy, objectArray.length, null);
                    }
                    start += toCopy;
                    remaining -= toCopy;
                }
            }
        }

        @Override
        public HugeObjectArray<T> copyOf(long newLength) {
            Class<?> tCls = this.page.getClass().getComponentType();
            HugeObjectArray<?> copy = HugeObjectArray.newArray(tCls, newLength);
            this.copyTo(copy, newLength);
            return copy;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return MemoryUsage.sizeOfObjectArray((long)this.size);
        }

        @Override
        public long release() {
            if (this.page != null) {
                this.page = null;
                return MemoryUsage.sizeOfObjectArray((long)this.size);
            }
            return 0L;
        }

        @Override
        public HugeCursor<T[]> newCursor() {
            return new HugeCursor.SinglePageCursor<T[]>(this.page);
        }

        @Override
        public T[] toArray() {
            return this.page;
        }

        @Override
        public String toString() {
            return Arrays.toString(this.page);
        }

        @Override
        Class<T> elementClass() {
            return this.page.getClass().getComponentType();
        }
    }
}

