/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public final class HugeMergeSort {
    private static final int SEQUENTIAL_THRESHOLD = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sort(HugeLongArray array, int concurrency) {
        HugeLongArray temp = HugeLongArray.newArray(array.size());
        ForkJoinPool forkJoinPool = Pools.createForkJoinPool(concurrency);
        try {
            forkJoinPool.invoke(new MergeSortTask(null, array, temp, 0L, array.size() - 1L));
        }
        finally {
            forkJoinPool.shutdown();
        }
    }

    private static void merge(HugeLongArray array, HugeLongArray temp, long startIndex, long endIndex, long midIndex) {
        for (long i = startIndex; i <= midIndex; ++i) {
            temp.set(i, array.get(i));
        }
        long left = startIndex;
        long right = midIndex + 1L;
        long i = startIndex;
        while (left <= midIndex && right <= endIndex) {
            if (temp.get(left) < array.get(right)) {
                array.set(i++, temp.get(left++));
                continue;
            }
            array.set(i++, array.get(right++));
        }
        if (left <= midIndex) {
            for (long k = i; k <= endIndex; ++k) {
                array.set(k, temp.get(left++));
            }
        }
    }

    private static void insertionSort(HugeLongArray array, long startIndex, long endIndex) {
        long i;
        long j = i = startIndex;
        while (i < endIndex) {
            long current = array.get(i + 1L);
            while (current < array.get(j)) {
                array.set(j + 1L, array.get(j));
                if (j-- != startIndex) continue;
            }
            array.set(j + 1L, current);
            j = ++i;
        }
    }

    private HugeMergeSort() {
    }

    static class MergeSortTask
    extends CountedCompleter<Void> {
        private final HugeLongArray array;
        private final HugeLongArray temp;
        private final long startIndex;
        private final long endIndex;
        private long midIndex;

        MergeSortTask(@Nullable CountedCompleter<?> completer, HugeLongArray array, HugeLongArray temp, long startIndex, long endIndex) {
            super(completer);
            this.array = array;
            this.temp = temp;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        @Override
        public void compute() {
            if (this.endIndex - this.startIndex >= 100L) {
                this.midIndex = this.startIndex + this.endIndex >>> 1;
                MergeSortTask leftTask = new MergeSortTask(this, this.array, this.temp, this.startIndex, this.midIndex);
                MergeSortTask rightTask = new MergeSortTask(this, this.array, this.temp, this.midIndex + 1L, this.endIndex);
                this.setPendingCount(1);
                leftTask.fork();
                rightTask.fork();
            } else {
                HugeMergeSort.insertionSort(this.array, this.startIndex, this.endIndex);
                this.tryComplete();
            }
        }

        @Override
        public void onCompletion(CountedCompleter<?> caller) {
            if (this.midIndex == 0L) {
                return;
            }
            HugeMergeSort.merge(this.array, this.temp, this.startIndex, this.endIndex, this.midIndex);
        }
    }
}

