/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeMatrices;

public class HugeLongTriangularMatrix {
    private final HugeLongArray array;
    private final long order;

    public HugeLongTriangularMatrix(long order) {
        long size = Math.multiplyExact(order, order + 1L) / 2L;
        this.order = order;
        this.array = HugeLongArray.newArray(size);
    }

    public void set(long x, long y, long v) {
        this.array.set(this.indexOf(x, y), v);
    }

    public long get(long x, long y) {
        return this.array.get(this.indexOf(x, y));
    }

    private long indexOf(long x, long y) {
        return HugeMatrices.triangularIndex(this.order, x, y);
    }
}

