/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import org.neo4j.gds.core.utils.paged.HugeLongArray;

public class HugeLongMatrix {
    private final HugeLongArray array;
    private final long rows;
    private final long cols;

    public HugeLongMatrix(long rows, long cols) {
        this.rows = rows;
        this.cols = cols;
        this.array = HugeLongArray.newArray(Math.multiplyExact(rows, cols));
    }

    public void set(long x, long y, long v) {
        assert (x < this.rows);
        assert (y < this.cols);
        this.array.set(this.indexOf(x, y), v);
    }

    public long get(long x, long y) {
        assert (x < this.rows);
        assert (y < this.cols);
        return this.array.get(this.indexOf(x, y));
    }

    private long indexOf(long x, long y) {
        return x * this.rows + y;
    }
}

