/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.cursors.LongLongCursor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.mem.BitUtil;

public final class HugeLongLongMap
implements Iterable<LongLongCursor> {
    private static final MemoryEstimation MEMORY_REQUIREMENTS = MemoryEstimations.builder(HugeLongLongMap.class).field("keysCursor", HugeCursor.class).field("entries", EntryIterator.class).perNode("keys", HugeLongArray::memoryEstimation).perNode("values", HugeLongArray::memoryEstimation).build();
    private HugeLongArray keys;
    private HugeLongArray values;
    private HugeCursor<long[]> keysCursor;
    private EntryIterator entries;
    private long assigned;
    private long mask;
    private long resizeAt;
    private static final long DEFAULT_EXPECTED_ELEMENTS = 4L;
    private static final double LOAD_FACTOR = 0.75;
    private static final int MIN_HASH_ARRAY_LENGTH = 4;

    public static MemoryEstimation memoryEstimation() {
        return MEMORY_REQUIREMENTS;
    }

    public HugeLongLongMap() {
        this(4L);
    }

    public HugeLongLongMap(long expectedElements) {
        this.initialBuffers(expectedElements);
    }

    public long sizeOf() {
        return this.keys.sizeOf() + this.values.sizeOf();
    }

    public void put(long key, long value) {
        this.put0(1L + key, value);
    }

    public void addTo(long key, long value) {
        this.addTo0(1L + key, value);
    }

    public long getOrDefault(long key, long defaultValue) {
        return this.getOrDefault0(1L + key, defaultValue);
    }

    public boolean containsKey(long key) {
        return this.containsKey0(1L + key);
    }

    private boolean containsKey0(long key) {
        long hash = BitMixer.mixPhi((long)key);
        return this.findSlot(key, hash & this.mask) >= 0L;
    }

    private void put0(long key, long value) {
        assert (this.assigned < this.mask + 1L);
        long hash = BitMixer.mixPhi((long)key);
        long slot = this.findSlot(key, hash & this.mask);
        assert (slot != -1L);
        if (slot >= 0L) {
            this.values.set(slot, value);
            return;
        }
        slot = 1L + slot ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            this.values.set(slot, value);
            this.keys.set(slot, key);
        }
        ++this.assigned;
    }

    private void addTo0(long key, long value) {
        assert (this.assigned < this.mask + 1L);
        long hash = BitMixer.mixPhi((long)key);
        long slot = this.findSlot(key, hash & this.mask);
        assert (slot != -1L);
        if (slot >= 0L) {
            this.values.addTo(slot, value);
            return;
        }
        slot = 1L + slot ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            this.values.set(slot, value);
            this.keys.set(slot, key);
        }
        ++this.assigned;
    }

    private long getOrDefault0(long key, long defaultValue) {
        long hash = BitMixer.mixPhi((long)key);
        long slot = this.findSlot(key, hash & this.mask);
        if (slot >= 0L) {
            return this.values.get(slot);
        }
        return defaultValue;
    }

    private long findSlot(long key, long start) {
        HugeLongArray keys = this.keys;
        HugeCursor<long[]> cursor = this.keysCursor;
        long slot = this.findSlot(key, start, keys.size(), keys, cursor);
        if (slot == -1L) {
            slot = this.findSlot(key, 0L, start, keys, cursor);
        }
        return slot;
    }

    private long findSlot(long key, long start, long end, HugeLongArray keys, HugeCursor<long[]> cursor) {
        long slot = start;
        keys.initCursor(cursor, start, end);
        while (cursor.next()) {
            long[] keysBlock = (long[])cursor.array;
            int blockPos = cursor.offset;
            int blockEnd = cursor.limit;
            while (blockPos < blockEnd) {
                long existing = keysBlock[blockPos];
                if (existing == key) {
                    return slot;
                }
                if (existing == 0L) {
                    return (slot ^ 0xFFFFFFFFFFFFFFFFL) - 1L;
                }
                ++blockPos;
                ++slot;
            }
        }
        return -1L;
    }

    public long size() {
        return this.assigned;
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public void clear() {
        this.assigned = 0L;
        this.keys.fill(0L);
        this.values.fill(0L);
    }

    public void release() {
        this.keys.release();
        this.values.release();
        this.keys = null;
        this.values = null;
        this.assigned = 0L;
        this.mask = 0L;
    }

    private void initialBuffers(long expectedElements) {
        this.allocateBuffers(HugeLongLongMap.minBufferSize(expectedElements));
    }

    @Override
    public Iterator<LongLongCursor> iterator() {
        return this.entries.reset();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        for (LongLongCursor cursor : this) {
            buffer.append(cursor.key).append("=>").append(cursor.value).append(", ");
        }
        if (buffer.length() > 1) {
            buffer.setLength(buffer.length() - 1);
            buffer.setCharAt(buffer.length() - 1, ']');
        } else {
            buffer.append(']');
        }
        return buffer.toString();
    }

    private void allocateBuffers(long arraySize) {
        assert (BitUtil.isPowerOfTwo((long)arraySize));
        HugeLongArray prevKeys = this.keys;
        HugeLongArray prevValues = this.values;
        try {
            this.keys = HugeLongArray.newArray(arraySize);
            this.values = HugeLongArray.newArray(arraySize);
            this.keysCursor = this.keys.newCursor();
            this.entries = new EntryIterator();
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw e;
        }
        this.resizeAt = HugeLongLongMap.expandAtCount(arraySize);
        this.mask = arraySize - 1L;
    }

    private void rehash(HugeLongArray fromKeys, HugeLongArray fromValues) {
        assert (fromKeys.size() == fromValues.size() && BitUtil.isPowerOfTwo((long)fromValues.size()));
        HugeLongArray newKeys = this.keys;
        HugeLongArray newValues = this.values;
        long mask = this.mask;
        try (EntryIterator fromEntries = new EntryIterator(fromKeys, fromValues);){
            for (LongLongCursor cursor : fromEntries) {
                long key = cursor.key + 1L;
                long slot = (long)BitMixer.mixPhi((long)key) & mask;
                slot = this.findSlot(key, slot);
                slot = 1L + slot ^ 0xFFFFFFFFFFFFFFFFL;
                newKeys.set(slot, key);
                newValues.set(slot, cursor.value);
            }
        }
    }

    private void allocateThenInsertThenRehash(long slot, long pendingKey, long pendingValue) {
        assert (this.assigned == this.resizeAt);
        HugeLongArray prevKeys = this.keys;
        HugeLongArray prevValues = this.values;
        this.allocateBuffers(HugeLongLongMap.nextBufferSize(this.mask + 1L));
        assert (this.keys.size() > prevKeys.size());
        prevKeys.set(slot, pendingKey);
        prevValues.set(slot, pendingValue);
        this.rehash(prevKeys, prevValues);
        prevKeys.release();
        prevValues.release();
    }

    private static long minBufferSize(long elements) {
        if (elements < 0L) {
            throw new IllegalArgumentException("Number of elements must be >= 0: " + elements);
        }
        long length = (long)Math.ceil((double)elements / 0.75);
        if (length == elements) {
            ++length;
        }
        length = Math.max(4L, BitUtil.nextHighestPowerOfTwo((long)length));
        return length;
    }

    private static long nextBufferSize(long arraySize) {
        assert (BitUtil.isPowerOfTwo((long)arraySize));
        return arraySize << 1;
    }

    private static long expandAtCount(long arraySize) {
        assert (BitUtil.isPowerOfTwo((long)arraySize));
        return Math.min(arraySize, (long)Math.ceil((double)arraySize * 0.75));
    }

    private final class EntryIterator
    implements AutoCloseable,
    Iterable<LongLongCursor>,
    Iterator<LongLongCursor> {
        private HugeCursor<long[]> keyCursor;
        private HugeCursor<long[]> valueCursor;
        private boolean nextFetched = false;
        private boolean hasNext = false;
        private LongLongCursor cursor;
        private int pos = 0;
        private int end = 0;
        private long[] ks;
        private long[] vs;

        EntryIterator() {
            this(hugeLongLongMap.keys, hugeLongLongMap.values);
        }

        EntryIterator(HugeLongArray keys, HugeLongArray values) {
            this.keyCursor = keys.initCursor(keys.newCursor());
            this.valueCursor = values.initCursor(values.newCursor());
            this.cursor = new LongLongCursor();
        }

        EntryIterator reset() {
            return this.reset(HugeLongLongMap.this.keys, HugeLongLongMap.this.values);
        }

        EntryIterator reset(HugeLongArray keys, HugeLongArray values) {
            this.keyCursor = keys.initCursor(this.keyCursor);
            this.valueCursor = values.initCursor(this.valueCursor);
            this.pos = 0;
            this.end = 0;
            this.hasNext = false;
            this.nextFetched = false;
            return this;
        }

        @Override
        public boolean hasNext() {
            if (!this.nextFetched) {
                this.nextFetched = true;
                this.hasNext = this.fetchNext();
                return this.hasNext;
            }
            return this.hasNext;
        }

        @Override
        public LongLongCursor next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextFetched = false;
            return this.cursor;
        }

        private boolean fetchNext() {
            while (true) {
                if (this.pos < this.end) {
                    long key = this.ks[this.pos];
                    if (key != 0L) {
                        this.cursor.index = this.pos;
                        this.cursor.key = key - 1L;
                        this.cursor.value = this.vs[this.pos];
                        ++this.pos;
                        return true;
                    }
                    ++this.pos;
                    continue;
                }
                if (!this.nextPage()) break;
            }
            return false;
        }

        private boolean nextPage() {
            return this.nextPage(this.keyCursor, this.valueCursor);
        }

        private boolean nextPage(HugeCursor<long[]> keys, HugeCursor<long[]> values) {
            boolean valuesHasNext = values.next();
            if (!keys.next()) {
                assert (!valuesHasNext);
                return false;
            }
            assert (valuesHasNext);
            this.ks = (long[])keys.array;
            this.pos = keys.offset;
            this.end = keys.limit;
            this.vs = (long[])values.array;
            assert (this.pos == values.offset);
            assert (this.end == values.limit);
            return true;
        }

        @Override
        public Iterator<LongLongCursor> iterator() {
            return this.reset();
        }

        @Override
        public void close() {
            this.keyCursor.close();
            this.keyCursor = null;
            this.valueCursor.close();
            this.valueCursor = null;
            this.cursor = null;
        }
    }
}

