/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.Containers;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.utils.CloseableThreadLocal;

public final class HugeLongLongDoubleMap {
    private HugeLongArray keys1;
    private HugeLongArray keys2;
    private HugeDoubleArray values;
    private CloseableThreadLocal<HugeCursor<long[]>> keysCursor;
    private int keyMixer;
    private long assigned;
    private long mask;
    private long resizeAt;
    private static final long DEFAULT_EXPECTED_ELEMENTS = 4L;
    private static final double LOAD_FACTOR = 0.75;
    private static final int MIN_HASH_ARRAY_LENGTH = 4;

    public HugeLongLongDoubleMap() {
        this(4L);
    }

    public HugeLongLongDoubleMap(long expectedElements) {
        this.initialBuffers(expectedElements);
    }

    public synchronized void set(long key1, long key2, double value) {
        this.set0(1L + key1, 1L + key2, value);
    }

    public void addTo(long key1, long key2, double value) {
        this.addTo0(1L + key1, 1L + key2, value);
    }

    public double getOrDefault(long key1, long key2, double defaultValue) {
        return this.getOrDefault0(1L + key1, 1L + key2, defaultValue);
    }

    private void set0(long key1, long key2, double value) {
        assert (this.assigned < this.mask + 1L);
        long key = this.hashKey(key1, key2);
        long slot = this.findSlot(key1, key2, key & this.mask);
        assert (slot != -1L);
        if (slot >= 0L) {
            this.values.set(slot, value);
            return;
        }
        slot = 1L + slot ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key1, key2, value);
        } else {
            this.keys1.set(slot, key1);
            this.keys2.set(slot, key2);
            this.values.set(slot, value);
        }
        ++this.assigned;
    }

    private void addTo0(long key1, long key2, double value) {
        assert (this.assigned < this.mask + 1L);
        long key = this.hashKey(key1, key2);
        long slot = this.findSlot(key1, key2, key & this.mask);
        assert (slot != -1L);
        if (slot >= 0L) {
            this.values.addTo(slot, value);
            return;
        }
        slot = 1L + slot ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key1, key2, value);
        } else {
            this.keys1.set(slot, key1);
            this.keys2.set(slot, key2);
            this.values.set(slot, value);
        }
        ++this.assigned;
    }

    private double getOrDefault0(long key1, long key2, double defaultValue) {
        long key = this.hashKey(key1, key2);
        long slot = this.findSlot(key1, key2, key & this.mask);
        if (slot >= 0L) {
            return this.values.get(slot);
        }
        return defaultValue;
    }

    private long findSlot(long key1, long key2, long start) {
        HugeLongArray keys1 = this.keys1;
        HugeLongArray keys2 = this.keys2;
        HugeCursor<long[]> cursor = this.keysCursor.get();
        long slot = this.findSlot(key1, key2, start, keys1.size(), keys1, keys2, cursor);
        if (slot == -1L) {
            slot = this.findSlot(key1, key2, 0L, start, keys1, keys2, cursor);
        }
        return slot;
    }

    private long findSlot(long key1, long key2, long start, long end, HugeLongArray keys1, HugeLongArray keys2, HugeCursor<long[]> cursor) {
        long slot = start;
        keys1.initCursor(cursor, start, end);
        while (cursor.next()) {
            long[] keysBlock = (long[])cursor.array;
            int blockPos = cursor.offset;
            int blockEnd = cursor.limit;
            while (blockPos < blockEnd) {
                long existing = keysBlock[blockPos];
                if (existing == key1 && keys2.get(slot) == key2) {
                    return slot;
                }
                if (existing == 0L) {
                    return (slot ^ 0xFFFFFFFFFFFFFFFFL) - 1L;
                }
                ++blockPos;
                ++slot;
            }
        }
        return -1L;
    }

    public long size() {
        return this.assigned;
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public void release() {
        this.keys1.release();
        this.keys2.release();
        this.values.release();
        this.keysCursor.close();
        this.keys1 = null;
        this.keys2 = null;
        this.values = null;
        this.assigned = 0L;
        this.mask = 0L;
    }

    private void initialBuffers(long expectedElements) {
        this.allocateBuffers(HugeLongLongDoubleMap.minBufferSize(expectedElements));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        HugeCursor<long[]> keys1 = this.keys1.initCursor(this.keys1.newCursor());
        HugeCursor<long[]> keys2 = this.keys2.initCursor(this.keys2.newCursor());
        HugeCursor<double[]> values = this.values.initCursor(this.values.newCursor());
        while (keys1.next()) {
            keys2.next();
            values.next();
            long[] ks1 = (long[])keys1.array;
            long[] ks2 = (long[])keys2.array;
            double[] vs = (double[])values.array;
            int end = keys1.limit;
            for (int pos = keys1.offset; pos < end; ++pos) {
                long key1 = ks1[pos];
                if (key1 == 0L) continue;
                buffer.append('(').append(key1 - 1L).append(',').append(ks2[pos] - 1L).append(")=>").append(vs[pos]).append(", ");
            }
        }
        if (buffer.length() > 1) {
            buffer.setLength(buffer.length() - 1);
            buffer.setCharAt(buffer.length() - 1, ']');
        } else {
            buffer.append(']');
        }
        return buffer.toString();
    }

    private long hashKey(long key1, long key2) {
        return BitMixer.mix64((long)(key1 ^ key2 ^ (long)this.keyMixer));
    }

    private void allocateBuffers(long arraySize) {
        assert (BitUtil.isPowerOfTwo((long)arraySize));
        int newKeyMixer = RandomSeed.next();
        HugeLongArray prevKeys1 = this.keys1;
        HugeLongArray prevKeys2 = this.keys2;
        HugeDoubleArray prevValues = this.values;
        try {
            this.keys1 = HugeLongArray.newArray(arraySize);
            this.keys2 = HugeLongArray.newArray(arraySize);
            this.values = HugeDoubleArray.newArray(arraySize);
            this.keysCursor = CloseableThreadLocal.withInitial(this.keys1::newCursor);
        }
        catch (OutOfMemoryError e) {
            this.keys1 = prevKeys1;
            this.keys2 = prevKeys2;
            this.values = prevValues;
            throw e;
        }
        this.resizeAt = HugeLongLongDoubleMap.expandAtCount(arraySize);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1L;
    }

    private void rehash(HugeLongArray fromKeys1, HugeLongArray fromKeys2, HugeDoubleArray fromValues) {
        assert (fromKeys1.size() == fromValues.size() && fromKeys2.size() == fromValues.size() && BitUtil.isPowerOfTwo((long)fromValues.size()));
        HugeLongArray newKeys1 = this.keys1;
        HugeLongArray newKeys2 = this.keys2;
        HugeDoubleArray newValues = this.values;
        long mask = this.mask;
        HugeCursor<long[]> keys1 = fromKeys1.initCursor(fromKeys1.newCursor());
        HugeCursor<long[]> keys2 = fromKeys2.initCursor(fromKeys2.newCursor());
        HugeCursor<double[]> values = fromValues.initCursor(fromValues.newCursor());
        while (keys1.next()) {
            keys2.next();
            values.next();
            long[] ks1 = (long[])keys1.array;
            long[] ks2 = (long[])keys2.array;
            double[] vs = (double[])values.array;
            int end = keys1.limit;
            for (int pos = keys1.offset; pos < end; ++pos) {
                long key1 = ks1[pos];
                if (key1 == 0L) continue;
                long key2 = ks2[pos];
                long slot = this.hashKey(key1, key2) & mask;
                slot = this.findSlot(key1, key2, slot);
                slot = 1L + slot ^ 0xFFFFFFFFFFFFFFFFL;
                newKeys1.set(slot, key1);
                newKeys2.set(slot, key2);
                newValues.set(slot, vs[pos]);
            }
        }
    }

    private void allocateThenInsertThenRehash(long slot, long pendingKey1, long pendingKey2, double pendingValue) {
        assert (this.assigned == this.resizeAt);
        HugeLongArray prevKeys1 = this.keys1;
        HugeLongArray prevKeys2 = this.keys2;
        HugeDoubleArray prevValues = this.values;
        this.allocateBuffers(HugeLongLongDoubleMap.nextBufferSize(this.mask + 1L));
        assert (this.keys1.size() > prevKeys1.size());
        prevKeys1.set(slot, pendingKey1);
        prevKeys2.set(slot, pendingKey2);
        prevValues.set(slot, pendingValue);
        this.rehash(prevKeys1, prevKeys2, prevValues);
        prevKeys1.release();
        prevKeys2.release();
        prevValues.release();
    }

    private static long minBufferSize(long elements) {
        if (elements < 0L) {
            throw new IllegalArgumentException("Number of elements must be >= 0: " + elements);
        }
        long length = (long)Math.ceil((double)elements / 0.75);
        if (length == elements) {
            ++length;
        }
        length = Math.max(4L, BitUtil.nextHighestPowerOfTwo((long)length));
        return length;
    }

    private static long nextBufferSize(long arraySize) {
        assert (BitUtil.isPowerOfTwo((long)arraySize));
        return arraySize << 1;
    }

    private static long expandAtCount(long arraySize) {
        assert (BitUtil.isPowerOfTwo((long)arraySize));
        return Math.min(arraySize, (long)Math.ceil((double)arraySize * 0.75));
    }

    private static final class RandomSeed {
        private static final RandomSeed INSTANCE = new RandomSeed();
        private final AtomicLong seed = new AtomicLong(Containers.randomSeed64());

        private static int next() {
            return INSTANCE.newSeed();
        }

        private RandomSeed() {
        }

        private int newSeed() {
            return (int)BitMixer.mix64((long)this.seed.incrementAndGet());
        }
    }
}

