/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public final class HugeLongArrayStack {
    private final HugeLongArray array;
    private final long capacity;
    private long size;

    public static HugeLongArrayStack newStack(long capacity) {
        return new HugeLongArrayStack(HugeLongArray.newArray(capacity));
    }

    public static MemoryEstimation memoryEstimation() {
        return MemoryEstimations.builder(HugeLongArrayStack.class).perNode("array", HugeLongArray::memoryEstimation).build();
    }

    private HugeLongArrayStack(HugeLongArray array) {
        this.capacity = array.size();
        this.array = array;
    }

    public void push(long v) {
        if (this.size == this.capacity) {
            throw new IndexOutOfBoundsException("Stack is full.");
        }
        this.array.set(this.size++, v);
    }

    public long pop() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Stack is empty.");
        }
        return this.array.get(--this.size);
    }

    public long size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }
}

