/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import org.neo4j.gds.core.utils.paged.HugeLongArray;

public final class HugeLongArrayQueue {
    private final HugeLongArray array;
    private final long capacity;
    private long head = 0L;
    private long tail = 0L;

    public static HugeLongArrayQueue newQueue(long capacity) {
        return new HugeLongArrayQueue(HugeLongArray.newArray(capacity + 1L));
    }

    private HugeLongArrayQueue(HugeLongArray array) {
        this.capacity = array.size();
        this.array = array;
    }

    public void add(long v) {
        long newTail = (this.tail + 1L) % this.capacity;
        if (newTail == this.head) {
            throw new IndexOutOfBoundsException("Queue is full.");
        }
        this.array.set(this.tail, v);
        this.tail = newTail;
    }

    public long remove() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Queue is empty.");
        }
        long removed = this.array.get(this.head);
        this.head = (this.head + 1L) % this.capacity;
        return removed;
    }

    public long size() {
        long diff = this.tail - this.head;
        if (diff < 0L) {
            diff += this.capacity;
        }
        return diff;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }
}

