/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.gds.core.loading.IdMapAllocator;
import org.neo4j.gds.core.utils.paged.HugeArrays;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public class HugeLongArrayBuilder {
    private long[][] pages = new long[0][0];
    private final Lock lock = new ReentrantLock();
    private static final VarHandle PAGES;

    public static HugeLongArrayBuilder newBuilder() {
        return new HugeLongArrayBuilder();
    }

    HugeLongArrayBuilder() {
    }

    public HugeLongArray build(long size) {
        VarHandle.fullFence();
        long[][] pages = PAGES.getVolatile(this);
        return HugeLongArray.of(pages, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocate(long start, int batchLength, Allocator allocator) {
        long[][] pages;
        int endPage = HugeArrays.pageIndex(start + (long)batchLength - 1L);
        if (endPage >= (pages = PAGES.getAcquire(this)).length) {
            this.lock.lock();
            try {
                pages = PAGES.getVolatile(this);
                if (endPage >= pages.length) {
                    long[][] newPages = (long[][])Arrays.copyOf(pages, endPage + 1);
                    for (int i = newPages.length - 1; i >= 0 && newPages[i] == null; --i) {
                        newPages[i] = new long[16384];
                    }
                    PAGES.setRelease(this, newPages);
                    pages = newPages;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        allocator.reset(start, start + (long)batchLength, pages);
    }

    static {
        try {
            PAGES = MethodHandles.lookup().findVarHandle(HugeLongArrayBuilder.class, "pages", long[][].class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static final class Allocator
    implements IdMapAllocator,
    AutoCloseable {
        private long[] buffer;
        private int allocationSize;
        private long start;
        private int offset;
        private int length;
        private final HugeCursor.PagedCursor<long[]> cursor = new HugeCursor.PagedCursor((Array[])new long[0][]);

        private void reset(long start, long end, long[][] pages) {
            this.cursor.setPages((Array[])pages);
            this.cursor.setRange(start, end);
            this.buffer = null;
            this.allocationSize = (int)(end - start);
            this.start = start;
            this.offset = 0;
            this.length = 0;
        }

        public boolean nextBuffer() {
            if (!this.cursor.next()) {
                return false;
            }
            this.start += (long)this.length;
            this.buffer = (long[])this.cursor.array;
            this.offset = this.cursor.offset;
            this.length = this.cursor.limit - this.cursor.offset;
            return true;
        }

        @Override
        public long startId() {
            return this.start;
        }

        @Override
        public int allocatedSize() {
            return this.allocationSize;
        }

        @Override
        public void insert(long[] nodeIds) {
            int batchOffset = 0;
            while (this.nextBuffer()) {
                System.arraycopy(nodeIds, batchOffset, this.buffer, this.offset, this.length);
                batchOffset += this.length;
            }
        }

        @Override
        public void close() {
            this.cursor.close();
        }
    }
}

