/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.Arrays;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.core.utils.ArrayUtil;
import org.neo4j.gds.core.utils.paged.HugeArray;
import org.neo4j.gds.core.utils.paged.HugeArrays;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.utils.StringFormatting;

public abstract class HugeLongArray
extends HugeArray<long[], Long, HugeLongArray> {
    public abstract long get(long var1);

    public abstract void set(long var1, long var3);

    public abstract void or(long var1, long var3);

    public abstract long and(long var1, long var3);

    public abstract void addTo(long var1, long var3);

    public abstract void setAll(LongUnaryOperator var1);

    public abstract void fill(long var1);

    @Override
    public abstract long size();

    @Override
    public abstract long sizeOf();

    public abstract long binarySearch(long var1);

    @Override
    public abstract long release();

    @Override
    public abstract HugeCursor<long[]> newCursor();

    @Override
    public abstract void copyTo(HugeLongArray var1, long var2);

    @Override
    public final HugeLongArray copyOf(long newLength) {
        HugeLongArray copy = HugeLongArray.newArray(newLength);
        this.copyTo(copy, newLength);
        return copy;
    }

    @Override
    final Long boxedGet(long index) {
        return this.get(index);
    }

    @Override
    final void boxedSet(long index, Long value) {
        this.set(index, value);
    }

    @Override
    final void boxedSetAll(LongFunction<Long> gen) {
        this.setAll(gen::apply);
    }

    @Override
    final void boxedFill(Long value) {
        this.fill(value);
    }

    @Override
    public long[] toArray() {
        return this.dumpToArray(long[].class);
    }

    @Override
    public LongNodePropertyValues asNodeProperties() {
        return new LongNodePropertyValues(){

            @Override
            public long longValue(long nodeId) {
                return HugeLongArray.this.get(nodeId);
            }

            @Override
            public long size() {
                return HugeLongArray.this.size();
            }
        };
    }

    public static HugeLongArray newArray(long size) {
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return SingleHugeLongArray.of(size);
        }
        return PagedHugeLongArray.of(size);
    }

    public static long memoryEstimation(long size) {
        assert (size >= 0L);
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return MemoryUsage.sizeOfInstance(SingleHugeLongArray.class) + MemoryUsage.sizeOfLongArray((long)((int)size));
        }
        long sizeOfInstance = MemoryUsage.sizeOfInstance(PagedHugeLongArray.class);
        int numPages = HugeArrays.numberOfPages(size);
        long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numPages);
        long pageBytes = MemoryUsage.sizeOfLongArray((long)16384L);
        int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
        return sizeOfInstance + (memoryUsed += (long)(numPages - 1) * pageBytes) + MemoryUsage.sizeOfLongArray((long)lastPageSize);
    }

    public static HugeLongArray of(long ... values) {
        return new SingleHugeLongArray(values.length, values);
    }

    public static HugeLongArray of(long[][] array, long size) {
        long capacity = PageUtil.capacityFor((int)array.length, (int)14);
        if (size > capacity) {
            throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Size should be smaller than or equal to capacity %d, but got size %d", (Object[])new Object[]{capacity, size}));
        }
        return new PagedHugeLongArray(size, array, PagedHugeLongArray.memoryUsed(array, capacity));
    }

    static HugeLongArray newPagedArray(long size) {
        return PagedHugeLongArray.of(size);
    }

    static HugeLongArray newSingleArray(int size) {
        return SingleHugeLongArray.of((long)size);
    }

    private static final class PagedHugeLongArray
    extends HugeLongArray {
        private final long size;
        private long[][] pages;
        private final long memoryUsed;

        private static HugeLongArray of(long size) {
            int numPages = HugeArrays.numberOfPages(size);
            long[][] pages = new long[numPages][];
            for (int i = 0; i < numPages - 1; ++i) {
                pages[i] = new long[16384];
            }
            int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
            pages[numPages - 1] = new long[lastPageSize];
            long memoryUsed = PagedHugeLongArray.memoryUsed(pages, size);
            return new PagedHugeLongArray(size, pages, memoryUsed);
        }

        static long memoryUsed(long[][] pages, long size) {
            int numPages = pages.length;
            long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numPages);
            long pageBytes = MemoryUsage.sizeOfLongArray((long)16384L);
            memoryUsed += pageBytes * (long)(numPages - 1);
            int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
            return memoryUsed += MemoryUsage.sizeOfLongArray((long)lastPageSize);
        }

        private PagedHugeLongArray(long size, long[][] pages, long memoryUsed) {
            this.size = size;
            this.pages = pages;
            this.memoryUsed = memoryUsed;
        }

        @Override
        public long get(long index) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return this.pages[pageIndex][indexInPage];
        }

        @Override
        public void set(long index, long value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            this.pages[pageIndex][indexInPage] = value;
        }

        @Override
        public void or(long index, long value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            long[] lArray = this.pages[pageIndex];
            int n = indexInPage;
            lArray[n] = lArray[n] | value;
        }

        @Override
        public long and(long index, long value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            long[] lArray = this.pages[pageIndex];
            int n = indexInPage;
            long l = lArray[n] & value;
            lArray[n] = l;
            return l;
        }

        @Override
        public void addTo(long index, long value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            long[] lArray = this.pages[pageIndex];
            int n = indexInPage;
            lArray[n] = lArray[n] + value;
        }

        @Override
        public void setAll(LongUnaryOperator gen) {
            for (int i = 0; i < this.pages.length; ++i) {
                long t = (long)i << 14;
                Arrays.setAll(this.pages[i], j -> gen.applyAsLong(t + (long)j));
            }
        }

        @Override
        public void fill(long value) {
            for (long[] page : this.pages) {
                Arrays.fill(page, value);
            }
        }

        @Override
        public void copyTo(HugeLongArray dest, long length) {
            if (length > this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeLongArray) {
                long[] page;
                int toCopy;
                SingleHugeLongArray dst = (SingleHugeLongArray)dest;
                int start = 0;
                int remaining = (int)length;
                long[][] lArray = this.pages;
                int n = lArray.length;
                for (int i = 0; i < n && (toCopy = Math.min(remaining, (page = lArray[i]).length)) != 0; ++i) {
                    System.arraycopy(page, 0, dst.page, start, toCopy);
                    start += toCopy;
                    remaining -= toCopy;
                }
                Arrays.fill(dst.page, start, dst.size, 0L);
            } else if (dest instanceof PagedHugeLongArray) {
                int i;
                PagedHugeLongArray dst = (PagedHugeLongArray)dest;
                int pageLen = Math.min(this.pages.length, dst.pages.length);
                int lastPage = pageLen - 1;
                long remaining = length;
                for (i = 0; i < lastPage; ++i) {
                    long[] page = this.pages[i];
                    long[] dstPage = dst.pages[i];
                    System.arraycopy(page, 0, dstPage, 0, page.length);
                    remaining -= (long)page.length;
                }
                if (remaining > 0L) {
                    System.arraycopy(this.pages[lastPage], 0, dst.pages[lastPage], 0, (int)remaining);
                    Arrays.fill(dst.pages[lastPage], (int)remaining, dst.pages[lastPage].length, 0L);
                }
                for (i = pageLen; i < dst.pages.length; ++i) {
                    Arrays.fill(dst.pages[i], 0L);
                }
            }
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return this.memoryUsed;
        }

        @Override
        public long binarySearch(long searchValue) {
            for (int pageIndex = this.pages.length - 1; pageIndex >= 0; --pageIndex) {
                long[] page = this.pages[pageIndex];
                int value = ArrayUtil.binaryLookup(searchValue, page);
                if (value == -1) continue;
                return HugeArrays.indexFromPageIndexAndIndexInPage(pageIndex, value);
            }
            return -1L;
        }

        @Override
        public long release() {
            if (this.pages != null) {
                this.pages = null;
                return this.memoryUsed;
            }
            return 0L;
        }

        @Override
        public HugeCursor<long[]> newCursor() {
            return new HugeCursor.PagedCursor<long[]>(this.size, (Array[])this.pages);
        }
    }

    private static final class SingleHugeLongArray
    extends HugeLongArray {
        private final int size;
        private long[] page;

        private static HugeLongArray of(long size) {
            assert (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH);
            int intSize = (int)size;
            long[] page = new long[intSize];
            return new SingleHugeLongArray(intSize, page);
        }

        private SingleHugeLongArray(int size, long[] page) {
            this.size = size;
            this.page = page;
        }

        @Override
        public long get(long index) {
            assert (index < (long)this.size) : "index = " + index + " size = " + this.size;
            return this.page[(int)index];
        }

        @Override
        public void set(long index, long value) {
            assert (index < (long)this.size);
            this.page[(int)index] = value;
        }

        @Override
        public void or(long index, long value) {
            assert (index < (long)this.size);
            int n = (int)index;
            this.page[n] = this.page[n] | value;
        }

        @Override
        public long and(long index, long value) {
            assert (index < (long)this.size);
            int n = (int)index;
            long l = this.page[n] & value;
            this.page[n] = l;
            return l;
        }

        @Override
        public void addTo(long index, long value) {
            assert (index < (long)this.size);
            int n = (int)index;
            this.page[n] = this.page[n] + value;
        }

        @Override
        public void setAll(LongUnaryOperator gen) {
            Arrays.setAll(this.page, gen::applyAsLong);
        }

        @Override
        public void fill(long value) {
            Arrays.fill(this.page, value);
        }

        @Override
        public void copyTo(HugeLongArray dest, long length) {
            if (length > (long)this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeLongArray) {
                SingleHugeLongArray dst = (SingleHugeLongArray)dest;
                System.arraycopy(this.page, 0, dst.page, 0, (int)length);
                Arrays.fill(dst.page, (int)length, dst.size, 0L);
            } else if (dest instanceof PagedHugeLongArray) {
                PagedHugeLongArray dst = (PagedHugeLongArray)dest;
                int start = 0;
                int remaining = (int)length;
                for (long[] dstPage : dst.pages) {
                    int toCopy = Math.min(remaining, dstPage.length);
                    if (toCopy == 0) {
                        Arrays.fill(this.page, 0L);
                        continue;
                    }
                    System.arraycopy(this.page, start, dstPage, 0, toCopy);
                    if (toCopy < dstPage.length) {
                        Arrays.fill(dstPage, toCopy, dstPage.length, 0L);
                    }
                    start += toCopy;
                    remaining -= toCopy;
                }
            }
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return MemoryUsage.sizeOfLongArray((long)this.size);
        }

        @Override
        public long binarySearch(long searchValue) {
            return ArrayUtil.binaryLookup(searchValue, this.page);
        }

        @Override
        public long release() {
            if (this.page != null) {
                this.page = null;
                return MemoryUsage.sizeOfLongArray((long)this.size);
            }
            return 0L;
        }

        @Override
        public HugeCursor<long[]> newCursor() {
            return new HugeCursor.SinglePageCursor<long[]>(this.page);
        }

        @Override
        public String toString() {
            return Arrays.toString(this.page);
        }

        @Override
        public long[] toArray() {
            return this.page;
        }
    }
}

