/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.Arrays;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.core.utils.ArrayUtil;
import org.neo4j.gds.core.utils.paged.HugeArray;
import org.neo4j.gds.core.utils.paged.HugeArrays;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class HugeIntArray
extends HugeArray<int[], Integer, HugeIntArray> {
    public abstract int get(long var1);

    public abstract int getAndAdd(long var1, int var3);

    public abstract void set(long var1, int var3);

    public abstract void or(long var1, int var3);

    public abstract int and(long var1, int var3);

    public abstract void addTo(long var1, int var3);

    public abstract void setAll(LongToIntFunction var1);

    public abstract void fill(int var1);

    @Override
    public abstract long size();

    @Override
    public abstract long sizeOf();

    @Override
    public abstract long release();

    @Override
    public abstract HugeCursor<int[]> newCursor();

    @Override
    public abstract void copyTo(HugeIntArray var1, long var2);

    @Override
    public final HugeIntArray copyOf(long newLength) {
        HugeIntArray copy = HugeIntArray.newArray(newLength);
        this.copyTo(copy, newLength);
        return copy;
    }

    @Override
    final Integer boxedGet(long index) {
        return this.get(index);
    }

    @Override
    final void boxedSet(long index, Integer value) {
        this.set(index, value);
    }

    @Override
    final void boxedSetAll(LongFunction<Integer> gen) {
        this.setAll(gen::apply);
    }

    @Override
    final void boxedFill(Integer value) {
        this.fill(value);
    }

    @Override
    public int[] toArray() {
        return this.dumpToArray(int[].class);
    }

    @Override
    public LongNodePropertyValues asNodeProperties() {
        return new LongNodePropertyValues(){

            @Override
            public long longValue(long nodeId) {
                return HugeIntArray.this.get(nodeId);
            }

            @Override
            public long size() {
                return HugeIntArray.this.size();
            }
        };
    }

    public static HugeIntArray newArray(long size) {
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return SingleHugeIntArray.of(size);
        }
        return PagedHugeIntArray.of(size);
    }

    public static HugeIntArray of(int ... values) {
        return new SingleHugeIntArray(values.length, values);
    }

    public static long memoryEstimation(long size) {
        assert (size >= 0L);
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return MemoryUsage.sizeOfInstance(SingleHugeIntArray.class) + MemoryUsage.sizeOfIntArray((long)((int)size));
        }
        long sizeOfInstance = MemoryUsage.sizeOfInstance(PagedHugeIntArray.class);
        int numPages = HugeArrays.numberOfPages(size);
        long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numPages);
        long pageBytes = MemoryUsage.sizeOfIntArray((long)16384L);
        int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
        return sizeOfInstance + (memoryUsed += (long)(numPages - 1) * pageBytes) + MemoryUsage.sizeOfIntArray((long)lastPageSize);
    }

    static HugeIntArray newPagedArray(long size) {
        return PagedHugeIntArray.of(size);
    }

    static HugeIntArray newSingleArray(int size) {
        return SingleHugeIntArray.of((long)size);
    }

    private static final class PagedHugeIntArray
    extends HugeIntArray {
        private final long size;
        private int[][] pages;
        private final long memoryUsed;

        private static HugeIntArray of(long size) {
            int numPages = HugeArrays.numberOfPages(size);
            int[][] pages = new int[numPages][];
            long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numPages);
            long pageBytes = MemoryUsage.sizeOfIntArray((long)16384L);
            for (int i = 0; i < numPages - 1; ++i) {
                memoryUsed += pageBytes;
                pages[i] = new int[16384];
            }
            int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
            pages[numPages - 1] = new int[lastPageSize];
            return new PagedHugeIntArray(size, pages, memoryUsed += MemoryUsage.sizeOfIntArray((long)lastPageSize));
        }

        private PagedHugeIntArray(long size, int[][] pages, long memoryUsed) {
            this.size = size;
            this.pages = pages;
            this.memoryUsed = memoryUsed;
        }

        @Override
        public int get(long index) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return this.pages[pageIndex][indexInPage];
        }

        @Override
        public int getAndAdd(long index, int delta) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            int value = this.pages[pageIndex][indexInPage];
            int[] nArray = this.pages[pageIndex];
            int n = indexInPage;
            nArray[n] = nArray[n] + delta;
            return value;
        }

        @Override
        public void set(long index, int value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            this.pages[pageIndex][indexInPage] = value;
        }

        @Override
        public void or(long index, int value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            int[] nArray = this.pages[pageIndex];
            int n = indexInPage;
            nArray[n] = nArray[n] | value;
        }

        @Override
        public int and(long index, int value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            int[] nArray = this.pages[pageIndex];
            int n = indexInPage;
            int n2 = nArray[n] & value;
            nArray[n] = n2;
            return n2;
        }

        @Override
        public void addTo(long index, int value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            int[] nArray = this.pages[pageIndex];
            int n = indexInPage;
            nArray[n] = nArray[n] + value;
        }

        @Override
        public void setAll(LongToIntFunction gen) {
            for (int i = 0; i < this.pages.length; ++i) {
                long t = (long)i << 14;
                Arrays.setAll(this.pages[i], j -> gen.applyAsInt(t + (long)j));
            }
        }

        @Override
        public void fill(int value) {
            for (int[] page : this.pages) {
                Arrays.fill(page, value);
            }
        }

        @Override
        public void copyTo(HugeIntArray dest, long length) {
            if (length > this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeIntArray) {
                int[] page;
                int toCopy;
                SingleHugeIntArray dst = (SingleHugeIntArray)dest;
                int start = 0;
                int remaining = (int)length;
                int[][] nArray = this.pages;
                int n = nArray.length;
                for (int i = 0; i < n && (toCopy = Math.min(remaining, (page = nArray[i]).length)) != 0; ++i) {
                    System.arraycopy(page, 0, dst.page, start, toCopy);
                    start += toCopy;
                    remaining -= toCopy;
                }
                Arrays.fill(dst.page, start, dst.size, 0);
            } else if (dest instanceof PagedHugeIntArray) {
                int i;
                PagedHugeIntArray dst = (PagedHugeIntArray)dest;
                int pageLen = Math.min(this.pages.length, dst.pages.length);
                int lastPage = pageLen - 1;
                long remaining = length;
                for (i = 0; i < lastPage; ++i) {
                    int[] page = this.pages[i];
                    int[] dstPage = dst.pages[i];
                    System.arraycopy(page, 0, dstPage, 0, page.length);
                    remaining -= (long)page.length;
                }
                if (remaining > 0L) {
                    System.arraycopy(this.pages[lastPage], 0, dst.pages[lastPage], 0, (int)remaining);
                    Arrays.fill(dst.pages[lastPage], (int)remaining, dst.pages[lastPage].length, 0);
                }
                for (i = pageLen; i < dst.pages.length; ++i) {
                    Arrays.fill(dst.pages[i], 0);
                }
            }
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return this.memoryUsed;
        }

        @Override
        public long release() {
            if (this.pages != null) {
                this.pages = null;
                return this.memoryUsed;
            }
            return 0L;
        }

        @Override
        public HugeCursor<int[]> newCursor() {
            return new HugeCursor.PagedCursor<int[]>(this.size, (Array[])this.pages);
        }
    }

    private static final class SingleHugeIntArray
    extends HugeIntArray {
        private final int size;
        private int[] page;

        private static HugeIntArray of(long size) {
            assert (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH);
            int intSize = (int)size;
            int[] page = new int[intSize];
            return new SingleHugeIntArray(intSize, page);
        }

        private SingleHugeIntArray(int size, int[] page) {
            this.size = size;
            this.page = page;
        }

        @Override
        public int get(long index) {
            assert (index < (long)this.size);
            return this.page[(int)index];
        }

        @Override
        public int getAndAdd(long index, int delta) {
            assert (index < (long)this.size);
            int idx = (int)index;
            int value = this.page[idx];
            int n = idx;
            this.page[n] = this.page[n] + delta;
            return value;
        }

        @Override
        public void set(long index, int value) {
            assert (index < (long)this.size);
            this.page[(int)index] = value;
        }

        @Override
        public void or(long index, int value) {
            assert (index < (long)this.size);
            int n = (int)index;
            this.page[n] = this.page[n] | value;
        }

        @Override
        public int and(long index, int value) {
            assert (index < (long)this.size);
            int n = (int)index;
            int n2 = this.page[n] & value;
            this.page[n] = n2;
            return n2;
        }

        @Override
        public void addTo(long index, int value) {
            assert (index < (long)this.size);
            int n = (int)index;
            this.page[n] = this.page[n] + value;
        }

        @Override
        public void setAll(LongToIntFunction gen) {
            Arrays.setAll(this.page, gen::applyAsInt);
        }

        @Override
        public void fill(int value) {
            Arrays.fill(this.page, value);
        }

        @Override
        public void copyTo(HugeIntArray dest, long length) {
            if (length > (long)this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeIntArray) {
                SingleHugeIntArray dst = (SingleHugeIntArray)dest;
                System.arraycopy(this.page, 0, dst.page, 0, (int)length);
                Arrays.fill(dst.page, (int)length, dst.size, 0);
            } else if (dest instanceof PagedHugeIntArray) {
                PagedHugeIntArray dst = (PagedHugeIntArray)dest;
                int start = 0;
                int remaining = (int)length;
                for (int[] dstPage : dst.pages) {
                    int toCopy = Math.min(remaining, dstPage.length);
                    if (toCopy == 0) {
                        Arrays.fill(this.page, 0);
                        continue;
                    }
                    System.arraycopy(this.page, start, dstPage, 0, toCopy);
                    if (toCopy < dstPage.length) {
                        Arrays.fill(dstPage, toCopy, dstPage.length, 0);
                    }
                    start += toCopy;
                    remaining -= toCopy;
                }
            }
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return MemoryUsage.sizeOfIntArray((long)this.size);
        }

        @Override
        public long release() {
            if (this.page != null) {
                this.page = null;
                return MemoryUsage.sizeOfIntArray((long)this.size);
            }
            return 0L;
        }

        @Override
        public HugeCursor<int[]> newCursor() {
            return new HugeCursor.SinglePageCursor<int[]>(this.page);
        }

        @Override
        public int[] toArray() {
            return this.page;
        }

        @Override
        public String toString() {
            return Arrays.toString(this.page);
        }
    }
}

