/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeMatrices;

public class HugeDoubleTriangularMatrix {
    private final HugeDoubleArray array;
    private final long order;

    public HugeDoubleTriangularMatrix(long order) {
        long size = Math.multiplyExact(order, order + 1L) / 2L;
        this.order = order;
        this.array = HugeDoubleArray.newArray(size);
    }

    public void set(long x, long y, double v) {
        this.array.set(this.indexOf(x, y), v);
    }

    public double get(long x, long y) {
        return this.array.get(this.indexOf(x, y));
    }

    public long order() {
        return this.order;
    }

    private long indexOf(long x, long y) {
        return HugeMatrices.triangularIndex(this.order, x, y);
    }
}

