/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import org.neo4j.gds.core.utils.paged.HugeDoubleArray;

public final class HugeDoubleArrayStack {
    private final HugeDoubleArray array;
    private final long capacity;
    private long size;

    public static HugeDoubleArrayStack newStack(long capacity) {
        return new HugeDoubleArrayStack(HugeDoubleArray.newArray(capacity));
    }

    private HugeDoubleArrayStack(HugeDoubleArray array) {
        this.capacity = array.size();
        this.array = array;
    }

    public void push(double v) {
        if (this.size == this.capacity) {
            throw new IndexOutOfBoundsException("Stack is full.");
        }
        this.array.set(this.size++, v);
    }

    public double pop() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Stack is empty.");
        }
        return this.array.get(--this.size);
    }

    public long size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }
}

