/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.Arrays;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.stream.DoubleStream;
import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.core.utils.ArrayUtil;
import org.neo4j.gds.core.utils.paged.HugeArray;
import org.neo4j.gds.core.utils.paged.HugeArrays;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class HugeDoubleArray
extends HugeArray<double[], Double, HugeDoubleArray> {
    public abstract double get(long var1);

    public abstract void set(long var1, double var3);

    public abstract void addTo(long var1, double var3);

    public abstract void setAll(LongToDoubleFunction var1);

    public abstract void fill(double var1);

    @Override
    public abstract long size();

    @Override
    public abstract long sizeOf();

    @Override
    public abstract long release();

    @Override
    public abstract HugeCursor<double[]> newCursor();

    public abstract DoubleStream stream();

    @Override
    public abstract void copyTo(HugeDoubleArray var1, long var2);

    @Override
    public final HugeDoubleArray copyOf(long newLength) {
        HugeDoubleArray copy = HugeDoubleArray.newArray(newLength);
        this.copyTo(copy, newLength);
        return copy;
    }

    @Override
    final Double boxedGet(long index) {
        return this.get(index);
    }

    @Override
    final void boxedSet(long index, Double value) {
        this.set(index, value);
    }

    @Override
    final void boxedSetAll(LongFunction<Double> gen) {
        this.setAll(gen::apply);
    }

    @Override
    final void boxedFill(Double value) {
        this.fill(value);
    }

    @Override
    public double[] toArray() {
        return this.dumpToArray(double[].class);
    }

    @Override
    public DoubleNodePropertyValues asNodeProperties() {
        return new DoubleNodePropertyValues(){

            @Override
            public double doubleValue(long nodeId) {
                return HugeDoubleArray.this.get(nodeId);
            }

            @Override
            public long size() {
                return HugeDoubleArray.this.size();
            }
        };
    }

    public static HugeDoubleArray newArray(long size) {
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return SingleHugeDoubleArray.of(size);
        }
        return PagedHugeDoubleArray.of(size);
    }

    public static long memoryEstimation(long size) {
        assert (size >= 0L);
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return MemoryUsage.sizeOfInstance(SingleHugeDoubleArray.class) + MemoryUsage.sizeOfDoubleArray((long)((int)size));
        }
        long sizeOfInstance = MemoryUsage.sizeOfInstance(PagedHugeDoubleArray.class);
        int numPages = HugeArrays.numberOfPages(size);
        long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numPages);
        long pageBytes = MemoryUsage.sizeOfDoubleArray((long)16384L);
        int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
        return sizeOfInstance + (memoryUsed += (long)(numPages - 1) * pageBytes) + MemoryUsage.sizeOfDoubleArray((long)lastPageSize);
    }

    public static HugeDoubleArray of(double ... values) {
        return new SingleHugeDoubleArray(values.length, values);
    }

    static HugeDoubleArray newPagedArray(long size) {
        return PagedHugeDoubleArray.of(size);
    }

    static HugeDoubleArray newSingleArray(int size) {
        return SingleHugeDoubleArray.of(size);
    }

    private static final class PagedHugeDoubleArray
    extends HugeDoubleArray {
        private final long size;
        private double[][] pages;
        private final long memoryUsed;

        private static HugeDoubleArray of(long size) {
            int numPages = HugeArrays.numberOfPages(size);
            double[][] pages = new double[numPages][];
            long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numPages);
            long pageBytes = MemoryUsage.sizeOfDoubleArray((long)16384L);
            for (int i = 0; i < numPages - 1; ++i) {
                memoryUsed += pageBytes;
                pages[i] = new double[16384];
            }
            int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
            pages[numPages - 1] = new double[lastPageSize];
            return new PagedHugeDoubleArray(size, pages, memoryUsed += MemoryUsage.sizeOfDoubleArray((long)lastPageSize));
        }

        private PagedHugeDoubleArray(long size, double[][] pages, long memoryUsed) {
            this.size = size;
            this.pages = pages;
            this.memoryUsed = memoryUsed;
        }

        @Override
        public double get(long index) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return this.pages[pageIndex][indexInPage];
        }

        @Override
        public void set(long index, double value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            this.pages[pageIndex][indexInPage] = value;
        }

        @Override
        public void addTo(long index, double value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            double[] dArray = this.pages[pageIndex];
            int n = indexInPage;
            dArray[n] = dArray[n] + value;
        }

        @Override
        public void setAll(LongToDoubleFunction gen) {
            for (int i = 0; i < this.pages.length; ++i) {
                long t = (long)i << 14;
                Arrays.setAll(this.pages[i], j -> gen.applyAsDouble(t + (long)j));
            }
        }

        @Override
        public void fill(double value) {
            for (double[] page : this.pages) {
                Arrays.fill(page, value);
            }
        }

        @Override
        public void copyTo(HugeDoubleArray dest, long length) {
            if (length > this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeDoubleArray) {
                double[] page;
                int toCopy;
                SingleHugeDoubleArray dst = (SingleHugeDoubleArray)dest;
                int start = 0;
                int remaining = (int)length;
                double[][] dArray = this.pages;
                int n = dArray.length;
                for (int i = 0; i < n && (toCopy = Math.min(remaining, (page = dArray[i]).length)) != 0; ++i) {
                    System.arraycopy(page, 0, dst.page, start, toCopy);
                    start += toCopy;
                    remaining -= toCopy;
                }
                Arrays.fill(dst.page, start, dst.size, 0.0);
            } else if (dest instanceof PagedHugeDoubleArray) {
                int i;
                PagedHugeDoubleArray dst = (PagedHugeDoubleArray)dest;
                int pageLen = Math.min(this.pages.length, dst.pages.length);
                int lastPage = pageLen - 1;
                long remaining = length;
                for (i = 0; i < lastPage; ++i) {
                    double[] page = this.pages[i];
                    double[] dstPage = dst.pages[i];
                    System.arraycopy(page, 0, dstPage, 0, page.length);
                    remaining -= (long)page.length;
                }
                if (remaining > 0L) {
                    System.arraycopy(this.pages[lastPage], 0, dst.pages[lastPage], 0, (int)remaining);
                    Arrays.fill(dst.pages[lastPage], (int)remaining, dst.pages[lastPage].length, 0.0);
                }
                for (i = pageLen; i < dst.pages.length; ++i) {
                    Arrays.fill(dst.pages[i], 0.0);
                }
            }
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return this.memoryUsed;
        }

        @Override
        public long release() {
            if (this.pages != null) {
                this.pages = null;
                return this.memoryUsed;
            }
            return 0L;
        }

        @Override
        public HugeCursor<double[]> newCursor() {
            return new HugeCursor.PagedCursor<double[]>(this.size, (Array[])this.pages);
        }

        @Override
        public DoubleStream stream() {
            return Arrays.stream(this.pages).flatMapToDouble(Arrays::stream);
        }
    }

    private static final class SingleHugeDoubleArray
    extends HugeDoubleArray {
        private final int size;
        private double[] page;

        private static HugeDoubleArray of(long size) {
            assert (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH);
            int intSize = (int)size;
            double[] page = new double[intSize];
            return new SingleHugeDoubleArray(intSize, page);
        }

        private SingleHugeDoubleArray(int size, double[] page) {
            this.size = size;
            this.page = page;
        }

        @Override
        public double get(long index) {
            assert (index < (long)this.size);
            return this.page[(int)index];
        }

        @Override
        public void set(long index, double value) {
            assert (index < (long)this.size);
            this.page[(int)index] = value;
        }

        @Override
        public void addTo(long index, double value) {
            assert (index < (long)this.size);
            int n = (int)index;
            this.page[n] = this.page[n] + value;
        }

        @Override
        public void setAll(LongToDoubleFunction gen) {
            Arrays.setAll(this.page, gen::applyAsDouble);
        }

        @Override
        public void fill(double value) {
            Arrays.fill(this.page, value);
        }

        @Override
        public void copyTo(HugeDoubleArray dest, long length) {
            if (length > (long)this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeDoubleArray) {
                SingleHugeDoubleArray dst = (SingleHugeDoubleArray)dest;
                System.arraycopy(this.page, 0, dst.page, 0, (int)length);
                Arrays.fill(dst.page, (int)length, dst.size, 0.0);
            } else if (dest instanceof PagedHugeDoubleArray) {
                PagedHugeDoubleArray dst = (PagedHugeDoubleArray)dest;
                int start = 0;
                int remaining = (int)length;
                for (double[] dstPage : dst.pages) {
                    int toCopy = Math.min(remaining, dstPage.length);
                    if (toCopy == 0) {
                        Arrays.fill(this.page, 0.0);
                        continue;
                    }
                    System.arraycopy(this.page, start, dstPage, 0, toCopy);
                    if (toCopy < dstPage.length) {
                        Arrays.fill(dstPage, toCopy, dstPage.length, 0.0);
                    }
                    start += toCopy;
                    remaining -= toCopy;
                }
            }
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return MemoryUsage.sizeOfDoubleArray((long)this.size);
        }

        @Override
        public long release() {
            if (this.page != null) {
                this.page = null;
                return MemoryUsage.sizeOfDoubleArray((long)this.size);
            }
            return 0L;
        }

        @Override
        public HugeCursor<double[]> newCursor() {
            return new HugeCursor.SinglePageCursor<double[]>(this.page);
        }

        @Override
        public DoubleStream stream() {
            return Arrays.stream(this.page);
        }

        @Override
        public double[] toArray() {
            return this.page;
        }

        @Override
        public String toString() {
            return Arrays.toString(this.page);
        }
    }
}

