/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.lang.reflect.Array;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.core.utils.paged.HugeArrays;

public abstract class HugeCursor<Array>
implements AutoCloseable {
    public long base;
    public Array array;
    public int offset;
    public int limit;

    HugeCursor() {
    }

    public abstract boolean next();

    @Override
    public abstract void close();

    abstract void setRange();

    abstract void setRange(long var1, long var3);

    public static final class PagedCursor<Array>
    extends HugeCursor<Array> {
        private Array[] pages;
        private int pageIndex;
        private int fromPage;
        private int maxPage;
        private long capacity;
        private long end;

        public PagedCursor(Array[] pages) {
            this.setPages(pages);
        }

        public PagedCursor(long capacity, Array[] pages) {
            this.setPages(pages, capacity);
        }

        public void setPages(Array[] pages) {
            this.setPages(pages, PageUtil.capacityFor((int)pages.length, (int)14));
        }

        public void setPages(Array[] pages, long capacity) {
            this.capacity = capacity;
            this.pages = pages;
        }

        @Override
        void setRange() {
            this.setRange(0L, this.capacity);
        }

        @Override
        void setRange(long start, long end) {
            this.fromPage = HugeArrays.pageIndex(start);
            this.maxPage = HugeArrays.pageIndex(end - 1L);
            this.pageIndex = this.fromPage - 1;
            this.end = end;
            this.base = (long)this.fromPage << 14;
            this.offset = HugeArrays.indexInPage(start);
            this.limit = this.fromPage == this.maxPage ? HugeArrays.exclusiveIndexOfPage(end) : 16384;
        }

        @Override
        public boolean next() {
            int current;
            if ((current = ++this.pageIndex) > this.maxPage) {
                return false;
            }
            this.array = this.pages[current];
            if (current == this.fromPage) {
                return true;
            }
            this.base += 16384L;
            this.offset = 0;
            this.limit = current == this.maxPage ? HugeArrays.exclusiveIndexOfPage(this.end) : Array.getLength(this.array);
            return true;
        }

        @Override
        public void close() {
            this.array = null;
            this.pages = null;
            this.base = 0L;
            this.end = 0L;
            this.limit = 0;
            this.capacity = 0L;
            this.maxPage = -1;
            this.fromPage = -1;
            this.pageIndex = -1;
        }
    }

    static final class SinglePageCursor<Array>
    extends HugeCursor<Array> {
        private boolean exhausted;

        SinglePageCursor(Array page) {
            this.array = page;
            this.base = 0L;
        }

        @Override
        void setRange() {
            this.setRange(0, Array.getLength(this.array));
        }

        @Override
        void setRange(long start, long end) {
            this.setRange((int)start, (int)end);
        }

        private void setRange(int start, int end) {
            this.exhausted = false;
            this.offset = start;
            this.limit = end;
        }

        @Override
        public final boolean next() {
            if (this.exhausted) {
                return false;
            }
            this.exhausted = true;
            return true;
        }

        @Override
        public void close() {
            this.array = null;
            this.limit = 0;
            this.exhausted = true;
        }
    }
}

