/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.Arrays;
import java.util.function.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToByteFunction;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.core.utils.ArrayUtil;
import org.neo4j.gds.core.utils.paged.HugeArray;
import org.neo4j.gds.core.utils.paged.HugeArrays;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class HugeByteArray
extends HugeArray<byte[], Byte, HugeByteArray> {
    public abstract byte get(long var1);

    public abstract byte getAndAdd(long var1, byte var3);

    public abstract void set(long var1, byte var3);

    public abstract void or(long var1, byte var3);

    public abstract byte and(long var1, byte var3);

    public abstract void addTo(long var1, byte var3);

    public abstract void setAll(LongToByteFunction var1);

    public abstract void fill(byte var1);

    @Override
    public abstract long size();

    @Override
    public abstract long sizeOf();

    @Override
    public abstract long release();

    @Override
    public abstract HugeCursor<byte[]> newCursor();

    @Override
    public abstract void copyTo(HugeByteArray var1, long var2);

    @Override
    final Byte boxedGet(long index) {
        return this.get(index);
    }

    @Override
    final void boxedSet(long index, Byte value) {
        this.set(index, value);
    }

    @Override
    final void boxedSetAll(LongFunction<Byte> gen) {
        this.setAll(gen::apply);
    }

    @Override
    final void boxedFill(Byte value) {
        this.fill(value);
    }

    @Override
    public byte[] toArray() {
        return this.dumpToArray(byte[].class);
    }

    @Override
    public final HugeByteArray copyOf(long newLength) {
        HugeByteArray copy = HugeByteArray.newArray(newLength);
        this.copyTo(copy, newLength);
        return copy;
    }

    @Override
    public LongNodePropertyValues asNodeProperties() {
        return new LongNodePropertyValues(){

            @Override
            public long longValue(long nodeId) {
                return HugeByteArray.this.get(nodeId);
            }

            @Override
            public long size() {
                return HugeByteArray.this.size();
            }
        };
    }

    public static HugeByteArray newArray(long size) {
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return SingleHugeByteArray.of(size);
        }
        return PagedHugeByteArray.of(size);
    }

    public static HugeByteArray of(byte ... values) {
        return new SingleHugeByteArray(values.length, values);
    }

    public static long memoryEstimation(long size) {
        assert (size >= 0L);
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return MemoryUsage.sizeOfInstance(SingleHugeByteArray.class) + MemoryUsage.sizeOfByteArray((long)((int)size));
        }
        long sizeOfInstance = MemoryUsage.sizeOfInstance(PagedHugeByteArray.class);
        int numPages = HugeArrays.numberOfPages(size);
        long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numPages);
        long pageBytes = MemoryUsage.sizeOfByteArray((long)16384L);
        int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
        return sizeOfInstance + (memoryUsed += (long)(numPages - 1) * pageBytes) + MemoryUsage.sizeOfByteArray((long)lastPageSize);
    }

    static HugeByteArray newPagedArray(long size) {
        return PagedHugeByteArray.of(size);
    }

    static HugeByteArray newSingleArray(int size) {
        return SingleHugeByteArray.of(size);
    }

    private static final class PagedHugeByteArray
    extends HugeByteArray {
        private final long size;
        private byte[][] pages;
        private final long memoryUsed;

        private static HugeByteArray of(long size) {
            int numPages = HugeArrays.numberOfPages(size);
            byte[][] pages = new byte[numPages][];
            long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numPages);
            long pageBytes = MemoryUsage.sizeOfByteArray((long)16384L);
            for (int i = 0; i < numPages - 1; ++i) {
                memoryUsed += pageBytes;
                pages[i] = new byte[16384];
            }
            int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
            pages[numPages - 1] = new byte[lastPageSize];
            return new PagedHugeByteArray(size, pages, memoryUsed += MemoryUsage.sizeOfByteArray((long)lastPageSize));
        }

        private PagedHugeByteArray(long size, byte[][] pages, long memoryUsed) {
            this.size = size;
            this.pages = pages;
            this.memoryUsed = memoryUsed;
        }

        @Override
        public byte get(long index) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return this.pages[pageIndex][indexInPage];
        }

        @Override
        public byte getAndAdd(long index, byte delta) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            byte value = this.pages[pageIndex][indexInPage];
            byte[] byArray = this.pages[pageIndex];
            int n = indexInPage;
            byArray[n] = (byte)(byArray[n] + delta);
            return value;
        }

        @Override
        public void set(long index, byte value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            this.pages[pageIndex][indexInPage] = value;
        }

        @Override
        public void or(long index, byte value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            byte[] byArray = this.pages[pageIndex];
            int n = indexInPage;
            byArray[n] = (byte)(byArray[n] | value);
        }

        @Override
        public byte and(long index, byte value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            byte[] byArray = this.pages[pageIndex];
            int n = indexInPage;
            byte by = (byte)(byArray[n] & value);
            byArray[n] = by;
            return by;
        }

        @Override
        public void addTo(long index, byte value) {
            assert (index < this.size);
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            byte[] byArray = this.pages[pageIndex];
            int n = indexInPage;
            byArray[n] = (byte)(byArray[n] + value);
        }

        @Override
        public void setAll(LongToByteFunction gen) {
            for (int i = 0; i < this.pages.length; ++i) {
                long t = (long)i << 14;
                for (int j = 0; j < this.pages[i].length; ++j) {
                    this.pages[i][j] = gen.valueOf(t + (long)j);
                }
            }
        }

        @Override
        public void fill(byte value) {
            for (byte[] page : this.pages) {
                Arrays.fill(page, value);
            }
        }

        @Override
        public void copyTo(HugeByteArray dest, long length) {
            if (length > this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeByteArray) {
                byte[] page;
                int toCopy;
                SingleHugeByteArray dst = (SingleHugeByteArray)dest;
                int start = 0;
                int remaining = (int)length;
                byte[][] byArray = this.pages;
                int n = byArray.length;
                for (int i = 0; i < n && (toCopy = Math.min(remaining, (page = byArray[i]).length)) != 0; ++i) {
                    System.arraycopy(page, 0, dst.page, start, toCopy);
                    start += toCopy;
                    remaining -= toCopy;
                }
                Arrays.fill(dst.page, start, dst.size, (byte)0);
            } else if (dest instanceof PagedHugeByteArray) {
                int i;
                PagedHugeByteArray dst = (PagedHugeByteArray)dest;
                int pageLen = Math.min(this.pages.length, dst.pages.length);
                int lastPage = pageLen - 1;
                long remaining = length;
                for (i = 0; i < lastPage; ++i) {
                    byte[] page = this.pages[i];
                    byte[] dstPage = dst.pages[i];
                    System.arraycopy(page, 0, dstPage, 0, page.length);
                    remaining -= (long)page.length;
                }
                if (remaining > 0L) {
                    System.arraycopy(this.pages[lastPage], 0, dst.pages[lastPage], 0, (int)remaining);
                    Arrays.fill(dst.pages[lastPage], (int)remaining, dst.pages[lastPage].length, (byte)0);
                }
                for (i = pageLen; i < dst.pages.length; ++i) {
                    Arrays.fill(dst.pages[i], (byte)0);
                }
            }
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return this.memoryUsed;
        }

        @Override
        public long release() {
            if (this.pages != null) {
                this.pages = null;
                return this.memoryUsed;
            }
            return 0L;
        }

        @Override
        public HugeCursor<byte[]> newCursor() {
            return new HugeCursor.PagedCursor<byte[]>(this.size, (Array[])this.pages);
        }
    }

    private static final class SingleHugeByteArray
    extends HugeByteArray {
        private final int size;
        private byte[] page;

        private static HugeByteArray of(long size) {
            assert (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH);
            int intSize = (int)size;
            byte[] page = new byte[intSize];
            return new SingleHugeByteArray(intSize, page);
        }

        private SingleHugeByteArray(int size, byte[] page) {
            this.size = size;
            this.page = page;
        }

        @Override
        public byte get(long index) {
            assert (index < (long)this.size);
            return this.page[(int)index];
        }

        @Override
        public byte getAndAdd(long index, byte delta) {
            assert (index < (long)this.size);
            int idx = (int)index;
            byte value = this.page[idx];
            int n = idx;
            this.page[n] = (byte)(this.page[n] + delta);
            return value;
        }

        @Override
        public void set(long index, byte value) {
            assert (index < (long)this.size);
            this.page[(int)index] = value;
        }

        @Override
        public void or(long index, byte value) {
            assert (index < (long)this.size);
            int n = (int)index;
            this.page[n] = (byte)(this.page[n] | value);
        }

        @Override
        public byte and(long index, byte value) {
            assert (index < (long)this.size);
            int n = (int)index;
            byte by = (byte)(this.page[n] & value);
            this.page[n] = by;
            return by;
        }

        @Override
        public void addTo(long index, byte value) {
            assert (index < (long)this.size);
            int n = (int)index;
            this.page[n] = (byte)(this.page[n] + value);
        }

        @Override
        public void setAll(LongToByteFunction gen) {
            for (int i = 0; i < this.page.length; ++i) {
                this.page[i] = gen.valueOf((long)i);
            }
        }

        @Override
        public void fill(byte value) {
            Arrays.fill(this.page, value);
        }

        @Override
        public void copyTo(HugeByteArray dest, long length) {
            if (length > (long)this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeByteArray) {
                SingleHugeByteArray dst = (SingleHugeByteArray)dest;
                System.arraycopy(this.page, 0, dst.page, 0, (int)length);
                Arrays.fill(dst.page, (int)length, dst.size, (byte)0);
            } else if (dest instanceof PagedHugeByteArray) {
                PagedHugeByteArray dst = (PagedHugeByteArray)dest;
                int start = 0;
                int remaining = (int)length;
                for (byte[] dstPage : dst.pages) {
                    int toCopy = Math.min(remaining, dstPage.length);
                    if (toCopy == 0) {
                        Arrays.fill(this.page, (byte)0);
                        continue;
                    }
                    System.arraycopy(this.page, start, dstPage, 0, toCopy);
                    if (toCopy < dstPage.length) {
                        Arrays.fill(dstPage, toCopy, dstPage.length, (byte)0);
                    }
                    start += toCopy;
                    remaining -= toCopy;
                }
            }
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return MemoryUsage.sizeOfByteArray((long)this.size);
        }

        @Override
        public long release() {
            if (this.page != null) {
                this.page = null;
                return MemoryUsage.sizeOfByteArray((long)this.size);
            }
            return 0L;
        }

        @Override
        public HugeCursor<byte[]> newCursor() {
            return new HugeCursor.SinglePageCursor<byte[]>(this.page);
        }

        @Override
        public byte[] toArray() {
            return this.page;
        }

        @Override
        public String toString() {
            return Arrays.toString(this.page);
        }
    }
}

