/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.function.LongUnaryOperator;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.core.utils.ArrayUtil;
import org.neo4j.gds.core.utils.paged.HugeArrays;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeCursorSupport;
import org.neo4j.gds.core.utils.paged.LongPageCreator;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class HugeAtomicLongArray
implements HugeCursorSupport<long[]> {
    @Override
    public abstract HugeCursor<long[]> newCursor();

    public abstract long get(long var1);

    public abstract long getAndAdd(long var1, long var3);

    public abstract void set(long var1, long var3);

    public abstract boolean compareAndSet(long var1, long var3, long var5);

    public abstract long compareAndExchange(long var1, long var3, long var5);

    public abstract void update(long var1, LongUnaryOperator var3);

    @Override
    public abstract long size();

    public abstract long sizeOf();

    public abstract void setAll(long var1);

    public abstract long release();

    public LongNodePropertyValues asNodeProperties() {
        return new LongNodePropertyValues(){

            @Override
            public long longValue(long nodeId) {
                return HugeAtomicLongArray.this.get(nodeId);
            }

            @Override
            public long size() {
                return HugeAtomicLongArray.this.size();
            }
        };
    }

    public abstract void copyTo(HugeAtomicLongArray var1, long var2);

    public static HugeAtomicLongArray newArray(long size) {
        return HugeAtomicLongArray.newArray(size, LongPageCreator.passThrough(1));
    }

    public static HugeAtomicLongArray newArray(long size, LongPageCreator pageFiller) {
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return SingleHugeAtomicLongArray.of(size, pageFiller);
        }
        return PagedHugeAtomicLongArray.of(size, pageFiller);
    }

    public static long memoryEstimation(long size) {
        long dataSize;
        long instanceSize;
        assert (size >= 0L);
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            instanceSize = MemoryUsage.sizeOfInstance(SingleHugeAtomicLongArray.class);
            dataSize = MemoryUsage.sizeOfLongArray((long)((int)size));
        } else {
            instanceSize = MemoryUsage.sizeOfInstance(PagedHugeAtomicLongArray.class);
            dataSize = PagedHugeAtomicLongArray.memoryUsageOfData(size);
        }
        return instanceSize + dataSize;
    }

    static HugeAtomicLongArray newPagedArray(long size, LongPageCreator pageFiller) {
        return PagedHugeAtomicLongArray.of(size, pageFiller);
    }

    static HugeAtomicLongArray newSingleArray(int size, LongPageCreator pageFiller) {
        return SingleHugeAtomicLongArray.of(size, pageFiller);
    }

    static final class PagedHugeAtomicLongArray
    extends HugeAtomicLongArray {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(long[].class);
        private final long size;
        private long[][] pages;
        private final long memoryUsed;

        private static HugeAtomicLongArray of(long size, LongPageCreator pageCreator) {
            int numPages = HugeArrays.numberOfPages(size);
            int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
            long[][] pages = new long[numPages][];
            pageCreator.fill(pages, lastPageSize);
            long memoryUsed = PagedHugeAtomicLongArray.memoryUsageOfData(size);
            return new PagedHugeAtomicLongArray(size, pages, memoryUsed);
        }

        private static long memoryUsageOfData(long size) {
            int numberOfPages = HugeArrays.numberOfPages(size);
            int numberOfFullPages = numberOfPages - 1;
            long bytesPerPage = MemoryUsage.sizeOfLongArray((long)16384L);
            int sizeOfLastPage = HugeArrays.exclusiveIndexOfPage(size);
            long bytesOfLastPage = MemoryUsage.sizeOfLongArray((long)sizeOfLastPage);
            long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numberOfPages);
            memoryUsed += (long)numberOfFullPages * bytesPerPage;
            return memoryUsed += bytesOfLastPage;
        }

        private PagedHugeAtomicLongArray(long size, long[][] pages, long memoryUsed) {
            this.size = size;
            this.pages = pages;
            this.memoryUsed = memoryUsed;
        }

        @Override
        public long get(long index) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return ARRAY_HANDLE.getVolatile(this.pages[pageIndex], indexInPage);
        }

        @Override
        public long getAndAdd(long index, long delta) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            long[] page = this.pages[pageIndex];
            long prev = ARRAY_HANDLE.getAcquire(page, indexInPage);
            long next;
            long current;
            while (prev != (current = ARRAY_HANDLE.compareAndExchangeRelease(page, indexInPage, prev, next = prev + delta))) {
                prev = current;
            }
            return prev;
        }

        @Override
        public void set(long index, long value) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            ARRAY_HANDLE.setVolatile(this.pages[pageIndex], indexInPage, value);
        }

        @Override
        public boolean compareAndSet(long index, long expect, long update) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return ARRAY_HANDLE.compareAndSet(this.pages[pageIndex], indexInPage, expect, update);
        }

        @Override
        public long compareAndExchange(long index, long expect, long update) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return ARRAY_HANDLE.compareAndExchange(this.pages[pageIndex], indexInPage, expect, update);
        }

        @Override
        public void update(long index, LongUnaryOperator updateFunction) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            long[] page = this.pages[pageIndex];
            long prev = ARRAY_HANDLE.getAcquire(page, indexInPage);
            long next;
            long current;
            while (prev != (current = ARRAY_HANDLE.compareAndExchangeRelease(page, indexInPage, prev, next = updateFunction.applyAsLong(prev)))) {
                prev = current;
            }
            return;
        }

        @Override
        public HugeCursor<long[]> newCursor() {
            return new HugeCursor.PagedCursor<long[]>(this.size, (Array[])this.pages);
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return this.memoryUsed;
        }

        @Override
        public void setAll(long value) {
            for (long[] page : this.pages) {
                Arrays.fill(page, value);
            }
            VarHandle.storeStoreFence();
        }

        @Override
        public long release() {
            if (this.pages != null) {
                this.pages = null;
                return this.memoryUsed;
            }
            return 0L;
        }

        @Override
        public void copyTo(HugeAtomicLongArray dest, long length) {
            if (length > this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeAtomicLongArray) {
                long[] page;
                int toCopy;
                SingleHugeAtomicLongArray dst = (SingleHugeAtomicLongArray)dest;
                int start = 0;
                int remaining = (int)length;
                long[][] lArray = this.pages;
                int n = lArray.length;
                for (int i = 0; i < n && (toCopy = Math.min(remaining, (page = lArray[i]).length)) != 0; ++i) {
                    System.arraycopy(page, 0, dst.page, start, toCopy);
                    start += toCopy;
                    remaining -= toCopy;
                }
                Arrays.fill(dst.page, start, dst.size, 0L);
            } else if (dest instanceof PagedHugeAtomicLongArray) {
                int i;
                PagedHugeAtomicLongArray dst = (PagedHugeAtomicLongArray)dest;
                int pageLen = Math.min(this.pages.length, dst.pages.length);
                int lastPage = pageLen - 1;
                long remaining = length;
                for (i = 0; i < lastPage; ++i) {
                    long[] page = this.pages[i];
                    long[] dstPage = dst.pages[i];
                    System.arraycopy(page, 0, dstPage, 0, page.length);
                    remaining -= (long)page.length;
                }
                if (remaining > 0L) {
                    System.arraycopy(this.pages[lastPage], 0, dst.pages[lastPage], 0, (int)remaining);
                    Arrays.fill(dst.pages[lastPage], (int)remaining, dst.pages[lastPage].length, 0L);
                }
                for (i = pageLen; i < dst.pages.length; ++i) {
                    Arrays.fill(dst.pages[i], 0L);
                }
            }
        }
    }

    static final class SingleHugeAtomicLongArray
    extends HugeAtomicLongArray {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(long[].class);
        private final int size;
        private long[] page;

        private static HugeAtomicLongArray of(long size, LongPageCreator pageCreator) {
            assert (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH);
            int intSize = (int)size;
            long[] page = new long[intSize];
            pageCreator.fillPage(page, 0L);
            return new SingleHugeAtomicLongArray(intSize, page);
        }

        private SingleHugeAtomicLongArray(int size, long[] page) {
            this.size = size;
            this.page = page;
        }

        @Override
        public HugeCursor<long[]> newCursor() {
            return new HugeCursor.SinglePageCursor<long[]>(this.page);
        }

        @Override
        public long get(long index) {
            return ARRAY_HANDLE.getVolatile(this.page, (int)index);
        }

        @Override
        public long getAndAdd(long index, long delta) {
            long prev = ARRAY_HANDLE.getAcquire(this.page, (int)index);
            long next;
            long current;
            while (prev != (current = ARRAY_HANDLE.compareAndExchangeRelease(this.page, (int)index, prev, next = prev + delta))) {
                prev = current;
            }
            return prev;
        }

        @Override
        public void set(long index, long value) {
            ARRAY_HANDLE.setVolatile(this.page, (int)index, value);
        }

        @Override
        public boolean compareAndSet(long index, long expect, long update) {
            return ARRAY_HANDLE.compareAndSet(this.page, (int)index, expect, update);
        }

        @Override
        public long compareAndExchange(long index, long expect, long update) {
            return ARRAY_HANDLE.compareAndExchange(this.page, (int)index, expect, update);
        }

        @Override
        public void update(long index, LongUnaryOperator updateFunction) {
            long prev = ARRAY_HANDLE.getAcquire(this.page, (int)index);
            long next;
            long current;
            while (prev != (current = ARRAY_HANDLE.compareAndExchangeRelease(this.page, (int)index, prev, next = updateFunction.applyAsLong(prev)))) {
                prev = current;
            }
            return;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return MemoryUsage.sizeOfLongArray((long)this.size);
        }

        @Override
        public void setAll(long value) {
            Arrays.fill(this.page, value);
            VarHandle.storeStoreFence();
        }

        @Override
        public long release() {
            if (this.page != null) {
                this.page = null;
                return MemoryUsage.sizeOfLongArray((long)this.size);
            }
            return 0L;
        }

        @Override
        public void copyTo(HugeAtomicLongArray dest, long length) {
            if (length > (long)this.size) {
                length = this.size;
            }
            if (length > dest.size()) {
                length = dest.size();
            }
            if (dest instanceof SingleHugeAtomicLongArray) {
                SingleHugeAtomicLongArray dst = (SingleHugeAtomicLongArray)dest;
                System.arraycopy(this.page, 0, dst.page, 0, (int)length);
                Arrays.fill(dst.page, (int)length, dst.size, 0L);
            } else if (dest instanceof PagedHugeAtomicLongArray) {
                PagedHugeAtomicLongArray dst = (PagedHugeAtomicLongArray)dest;
                int start = 0;
                int remaining = (int)length;
                for (long[] dstPage : dst.pages) {
                    int toCopy = Math.min(remaining, dstPage.length);
                    if (toCopy == 0) {
                        Arrays.fill(this.page, 0L);
                        continue;
                    }
                    System.arraycopy(this.page, start, dstPage, 0, toCopy);
                    if (toCopy < dstPage.length) {
                        Arrays.fill(dstPage, toCopy, dstPage.length, 0L);
                    }
                    start += toCopy;
                    remaining -= toCopy;
                }
            }
        }
    }
}

