/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSetOps;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.mem.HugeArrays;

public final class HugeAtomicGrowingBitSet {
    private static final int NUM_BITS = 64;
    private HugeAtomicLongArray bits;
    private long numBits;
    private int remainder;
    private final Lock growLock = new ReentrantLock(true);

    public static HugeAtomicGrowingBitSet create(long size) {
        long wordsSize = BitUtil.ceilDiv((long)size, (long)64L);
        int remainder = (int)(size % 64L);
        return new HugeAtomicGrowingBitSet(HugeAtomicLongArray.newArray(wordsSize), size, remainder);
    }

    private HugeAtomicGrowingBitSet(HugeAtomicLongArray bits, long numBits, int remainder) {
        this.bits = bits;
        this.numBits = numBits;
        this.remainder = remainder;
    }

    public boolean get(long index) {
        return HugeAtomicBitSetOps.get(this.bits, this.numBits, index);
    }

    public void set(long index) {
        if (index >= this.numBits) {
            this.grow(index + 1L);
        }
        HugeAtomicBitSetOps.set(this.bits, this.numBits, index);
    }

    public void set(long startIndex, long endIndex) {
        if (endIndex > this.numBits) {
            this.grow(endIndex);
        }
        HugeAtomicBitSetOps.setRange(this.bits, this.numBits, startIndex, endIndex);
    }

    public boolean getAndSet(long index) {
        if (index >= this.numBits) {
            this.grow(index + 1L);
        }
        return HugeAtomicBitSetOps.getAndSet(this.bits, this.numBits, index);
    }

    public void flip(long index) {
        if (index >= this.numBits) {
            this.grow(index + 1L);
        }
        HugeAtomicBitSetOps.flip(this.bits, this.numBits, index);
    }

    public void forEachSetBit(LongConsumer consumer) {
        HugeAtomicBitSetOps.forEachSetBit(this.bits, consumer);
    }

    public long cardinality() {
        return HugeAtomicBitSetOps.cardinality(this.bits);
    }

    public boolean isEmpty() {
        return HugeAtomicBitSetOps.isEmpty(this.bits);
    }

    public boolean allSet() {
        return HugeAtomicBitSetOps.allSet(this.bits, this.remainder);
    }

    public long size() {
        return this.numBits;
    }

    public void clear() {
        HugeAtomicBitSetOps.clear(this.bits);
    }

    public void clear(long index) {
        HugeAtomicBitSetOps.clear(this.bits, this.numBits, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grow(long minNumBits) {
        this.growLock.lock();
        try {
            if (minNumBits < this.numBits) {
                return;
            }
            long newNumBits = HugeArrays.oversize((long)minNumBits, (int)8);
            long wordsSize = BitUtil.ceilDiv((long)newNumBits, (long)64L);
            int remainder = (int)(newNumBits % 64L);
            HugeAtomicLongArray newBits = HugeAtomicLongArray.newArray(wordsSize);
            this.bits.copyTo(newBits, this.bits.size());
            this.bits = newBits;
            this.numBits = newNumBits;
            this.remainder = remainder;
        }
        finally {
            this.growLock.unlock();
        }
    }
}

