/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.core.utils.ArrayUtil;
import org.neo4j.gds.core.utils.paged.DoublePageCreator;
import org.neo4j.gds.core.utils.paged.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class HugeAtomicDoubleArray {
    public abstract double get(long var1);

    public abstract double getAndAdd(long var1, double var3);

    public abstract void set(long var1, double var3);

    public abstract double getAndReplace(long var1, double var3);

    public abstract boolean compareAndSet(long var1, double var3, double var5);

    public abstract double compareAndExchange(long var1, double var3, double var5);

    public abstract void update(long var1, DoubleUnaryOperator var3);

    public abstract long size();

    public abstract long sizeOf();

    public abstract void setAll(double var1);

    public abstract long release();

    public DoubleNodePropertyValues asNodeProperties() {
        return new DoubleNodePropertyValues(){

            @Override
            public double doubleValue(long nodeId) {
                return HugeAtomicDoubleArray.this.get(nodeId);
            }

            @Override
            public long size() {
                return HugeAtomicDoubleArray.this.size();
            }
        };
    }

    public static HugeAtomicDoubleArray newArray(long size) {
        return HugeAtomicDoubleArray.newArray(size, DoublePageCreator.passThrough(1));
    }

    public static HugeAtomicDoubleArray newArray(long size, DoublePageCreator pageFiller) {
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return SingleHugeAtomicDoubleArray.of(size, pageFiller);
        }
        return PagedHugeAtomicDoubleArray.of(size, pageFiller);
    }

    public static long memoryEstimation(long size) {
        long dataSize;
        long instanceSize;
        assert (size >= 0L);
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            instanceSize = MemoryUsage.sizeOfInstance(SingleHugeAtomicDoubleArray.class);
            dataSize = MemoryUsage.sizeOfLongArray((long)((int)size));
        } else {
            instanceSize = MemoryUsage.sizeOfInstance(PagedHugeAtomicDoubleArray.class);
            dataSize = PagedHugeAtomicDoubleArray.memoryUsageOfData(size);
        }
        return instanceSize + dataSize;
    }

    @TestOnly
    static HugeAtomicDoubleArray newPagedArray(long size, DoublePageCreator pageFiller) {
        return PagedHugeAtomicDoubleArray.of(size, pageFiller);
    }

    @TestOnly
    static HugeAtomicDoubleArray newSingleArray(int size, DoublePageCreator pageFiller) {
        return SingleHugeAtomicDoubleArray.of(size, pageFiller);
    }

    static final class PagedHugeAtomicDoubleArray
    extends HugeAtomicDoubleArray {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(double[].class);
        private final long size;
        private double[][] pages;
        private final long memoryUsed;

        private static HugeAtomicDoubleArray of(long size, DoublePageCreator pageCreator) {
            int numPages = HugeArrays.numberOfPages(size);
            int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
            double[][] pages = new double[numPages][];
            pageCreator.fill(pages, lastPageSize);
            long memoryUsed = PagedHugeAtomicDoubleArray.memoryUsageOfData(size);
            return new PagedHugeAtomicDoubleArray(size, pages, memoryUsed);
        }

        private static long memoryUsageOfData(long size) {
            int numberOfPages = HugeArrays.numberOfPages(size);
            int numberOfFullPages = numberOfPages - 1;
            long bytesPerPage = MemoryUsage.sizeOfDoubleArray((long)16384L);
            int sizeOfLastPage = HugeArrays.exclusiveIndexOfPage(size);
            long bytesOfLastPage = MemoryUsage.sizeOfDoubleArray((long)sizeOfLastPage);
            long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numberOfPages);
            memoryUsed += (long)numberOfFullPages * bytesPerPage;
            return memoryUsed += bytesOfLastPage;
        }

        private PagedHugeAtomicDoubleArray(long size, double[][] pages, long memoryUsed) {
            this.size = size;
            this.pages = pages;
            this.memoryUsed = memoryUsed;
        }

        @Override
        public double get(long index) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return ARRAY_HANDLE.getVolatile(this.pages[pageIndex], indexInPage);
        }

        @Override
        public double getAndAdd(long index, double delta) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            double[] page = this.pages[pageIndex];
            double prev = ARRAY_HANDLE.getAcquire(page, indexInPage);
            double next;
            double current;
            while (Double.compare(prev, current = ARRAY_HANDLE.compareAndExchangeRelease(page, indexInPage, prev, next = prev + delta)) != 0) {
                prev = current;
            }
            return prev;
        }

        @Override
        public void set(long index, double value) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            ARRAY_HANDLE.setVolatile(this.pages[pageIndex], indexInPage, value);
        }

        @Override
        public double getAndReplace(long index, double value) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            double[] page = this.pages[pageIndex];
            double prev = ARRAY_HANDLE.getAcquire(page, indexInPage);
            double current;
            while (Double.compare(current = ARRAY_HANDLE.compareAndExchangeRelease(page, indexInPage, prev, value), prev) != 0) {
                prev = current;
            }
            return current;
        }

        @Override
        public boolean compareAndSet(long index, double expect, double update) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return ARRAY_HANDLE.compareAndSet(this.pages[pageIndex], indexInPage, expect, update);
        }

        @Override
        public double compareAndExchange(long index, double expect, double update) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return ARRAY_HANDLE.compareAndExchange(this.pages[pageIndex], indexInPage, expect, update);
        }

        @Override
        public void update(long index, DoubleUnaryOperator updateFunction) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            double[] page = this.pages[pageIndex];
            double prev = ARRAY_HANDLE.getAcquire(page, indexInPage);
            double next;
            double current;
            while (Double.compare(current = ARRAY_HANDLE.compareAndExchangeRelease(page, indexInPage, prev, next = updateFunction.applyAsDouble(prev)), prev) != 0) {
                prev = current;
            }
            return;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return this.memoryUsed;
        }

        @Override
        public void setAll(double value) {
            for (double[] page : this.pages) {
                Arrays.fill(page, value);
            }
            VarHandle.storeStoreFence();
        }

        @Override
        public long release() {
            if (this.pages != null) {
                this.pages = null;
                return this.memoryUsed;
            }
            return 0L;
        }
    }

    private static final class SingleHugeAtomicDoubleArray
    extends HugeAtomicDoubleArray {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(double[].class);
        private final int size;
        private double[] page;

        private static HugeAtomicDoubleArray of(long size, DoublePageCreator pageCreator) {
            assert (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH);
            int intSize = (int)size;
            double[] page = new double[intSize];
            pageCreator.fillPage(page, 0L);
            return new SingleHugeAtomicDoubleArray(intSize, page);
        }

        private SingleHugeAtomicDoubleArray(int size, double[] page) {
            this.size = size;
            this.page = page;
        }

        @Override
        public double get(long index) {
            return ARRAY_HANDLE.getVolatile(this.page, (int)index);
        }

        @Override
        public double getAndAdd(long index, double delta) {
            double prev = ARRAY_HANDLE.getAcquire(this.page, (int)index);
            double next;
            double current;
            while (Double.compare(prev, current = ARRAY_HANDLE.compareAndExchangeRelease(this.page, (int)index, prev, next = prev + delta)) != 0) {
                prev = current;
            }
            return prev;
        }

        @Override
        public void set(long index, double value) {
            ARRAY_HANDLE.setVolatile(this.page, (int)index, value);
        }

        @Override
        public double getAndReplace(long index, double value) {
            double prev = ARRAY_HANDLE.getAcquire(this.page, (int)index);
            double current;
            while (Double.compare(current = ARRAY_HANDLE.compareAndExchangeRelease(this.page, (int)index, prev, value), prev) != 0) {
                prev = current;
            }
            return current;
        }

        @Override
        public boolean compareAndSet(long index, double expect, double update) {
            return ARRAY_HANDLE.compareAndSet(this.page, (int)index, expect, update);
        }

        @Override
        public double compareAndExchange(long index, double expect, double update) {
            return ARRAY_HANDLE.compareAndExchange(this.page, (int)index, expect, update);
        }

        @Override
        public void update(long index, DoubleUnaryOperator updateFunction) {
            double prev = ARRAY_HANDLE.getAcquire(this.page, (int)index);
            double next;
            double current;
            while (Double.compare(prev, current = ARRAY_HANDLE.compareAndExchangeRelease(this.page, (int)index, prev, next = updateFunction.applyAsDouble(prev))) != 0) {
                prev = current;
            }
            return;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return MemoryUsage.sizeOfLongArray((long)this.size);
        }

        @Override
        public void setAll(double value) {
            Arrays.fill(this.page, value);
            VarHandle.storeStoreFence();
        }

        @Override
        public long release() {
            if (this.page != null) {
                this.page = null;
                return MemoryUsage.sizeOfLongArray((long)this.size);
            }
            return 0L;
        }
    }
}

