/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.core.utils.ArrayUtil;
import org.neo4j.gds.core.utils.paged.BytePageCreator;
import org.neo4j.gds.core.utils.paged.HugeArrays;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeCursorSupport;
import org.neo4j.gds.mem.MemoryUsage;

public abstract class HugeAtomicByteArray
implements HugeCursorSupport<byte[]> {
    @Override
    public abstract HugeCursor<byte[]> newCursor();

    public abstract byte get(long var1);

    public abstract byte getAndAdd(long var1, byte var3);

    public abstract void set(long var1, byte var3);

    public abstract boolean compareAndSet(long var1, byte var3, byte var4);

    public abstract byte compareAndExchange(long var1, byte var3, byte var4);

    @Override
    public abstract long size();

    public abstract long sizeOf();

    public abstract void setAll(byte var1);

    public abstract long release();

    public static HugeAtomicByteArray newArray(long size) {
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            return SingleHugeAtomicByteArray.of(size);
        }
        return PagedHugeAtomicByteArray.of(size, BytePageCreator.of(1));
    }

    public static long memoryEstimation(long size) {
        long dataSize;
        long instanceSize;
        assert (size >= 0L);
        if (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            instanceSize = MemoryUsage.sizeOfInstance(SingleHugeAtomicByteArray.class);
            dataSize = MemoryUsage.sizeOfByteArray((long)((int)size));
        } else {
            instanceSize = MemoryUsage.sizeOfInstance(PagedHugeAtomicByteArray.class);
            dataSize = PagedHugeAtomicByteArray.memoryUsageOfData(size);
        }
        return instanceSize + dataSize;
    }

    @TestOnly
    static HugeAtomicByteArray newPagedArray(long size, BytePageCreator pageFiller) {
        return PagedHugeAtomicByteArray.of(size, pageFiller);
    }

    @TestOnly
    static HugeAtomicByteArray newSingleArray(int size) {
        return SingleHugeAtomicByteArray.of(size);
    }

    static final class PagedHugeAtomicByteArray
    extends HugeAtomicByteArray {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(byte[].class);
        private final long size;
        private byte[][] pages;
        private final long memoryUsed;

        private static HugeAtomicByteArray of(long size, BytePageCreator pageCreator) {
            int numPages = HugeArrays.numberOfPages(size);
            int lastPageSize = HugeArrays.exclusiveIndexOfPage(size);
            byte[][] pages = new byte[numPages][];
            pageCreator.fill(pages, lastPageSize);
            long memoryUsed = PagedHugeAtomicByteArray.memoryUsageOfData(size);
            return new PagedHugeAtomicByteArray(size, pages, memoryUsed);
        }

        private static long memoryUsageOfData(long size) {
            int numberOfPages = HugeArrays.numberOfPages(size);
            int numberOfFullPages = numberOfPages - 1;
            long bytesPerPage = MemoryUsage.sizeOfByteArray((long)16384L);
            int sizeOfLastPage = HugeArrays.exclusiveIndexOfPage(size);
            long bytesOfLastPage = MemoryUsage.sizeOfByteArray((long)sizeOfLastPage);
            long memoryUsed = MemoryUsage.sizeOfObjectArray((long)numberOfPages);
            memoryUsed += (long)numberOfFullPages * bytesPerPage;
            return memoryUsed += bytesOfLastPage;
        }

        private PagedHugeAtomicByteArray(long size, byte[][] pages, long memoryUsed) {
            this.size = size;
            this.pages = pages;
            this.memoryUsed = memoryUsed;
        }

        @Override
        public byte get(long index) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return ARRAY_HANDLE.getVolatile(this.pages[pageIndex], indexInPage);
        }

        @Override
        public byte getAndAdd(long index, byte delta) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            byte[] page = this.pages[pageIndex];
            byte prev = ARRAY_HANDLE.getAcquire(page, indexInPage);
            byte next;
            byte current;
            while (prev != (current = ARRAY_HANDLE.compareAndExchangeRelease(page, indexInPage, prev, next = (byte)(prev + delta)))) {
                prev = current;
            }
            return prev;
        }

        @Override
        public void set(long index, byte value) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            ARRAY_HANDLE.setVolatile(this.pages[pageIndex], indexInPage, value);
        }

        @Override
        public boolean compareAndSet(long index, byte expect, byte update) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return ARRAY_HANDLE.compareAndSet(this.pages[pageIndex], indexInPage, expect, update);
        }

        @Override
        public byte compareAndExchange(long index, byte expect, byte update) {
            int pageIndex = HugeArrays.pageIndex(index);
            int indexInPage = HugeArrays.indexInPage(index);
            return ARRAY_HANDLE.compareAndExchange(this.pages[pageIndex], indexInPage, expect, update);
        }

        @Override
        public HugeCursor<byte[]> newCursor() {
            return new HugeCursor.PagedCursor<byte[]>(this.size, (Array[])this.pages);
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return this.memoryUsed;
        }

        @Override
        public void setAll(byte value) {
            for (byte[] page : this.pages) {
                Arrays.fill(page, value);
            }
            VarHandle.storeStoreFence();
        }

        @Override
        public long release() {
            if (this.pages != null) {
                this.pages = null;
                return this.memoryUsed;
            }
            return 0L;
        }
    }

    static final class SingleHugeAtomicByteArray
    extends HugeAtomicByteArray {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(byte[].class);
        private final int size;
        private byte[] page;

        private static HugeAtomicByteArray of(long size) {
            assert (size <= (long)ArrayUtil.MAX_ARRAY_LENGTH);
            int intSize = (int)size;
            byte[] page = new byte[intSize];
            return new SingleHugeAtomicByteArray(intSize, page);
        }

        private SingleHugeAtomicByteArray(int size, byte[] page) {
            this.size = size;
            this.page = page;
        }

        @Override
        public HugeCursor<byte[]> newCursor() {
            return new HugeCursor.SinglePageCursor<byte[]>(this.page);
        }

        @Override
        public byte get(long index) {
            return ARRAY_HANDLE.getVolatile(this.page, (int)index);
        }

        @Override
        public byte getAndAdd(long index, byte delta) {
            byte prev = ARRAY_HANDLE.getAcquire(this.page, (int)index);
            byte next;
            byte current;
            while (prev != (current = ARRAY_HANDLE.compareAndExchangeRelease(this.page, (int)index, prev, next = (byte)(prev + delta)))) {
                prev = current;
            }
            return prev;
        }

        @Override
        public void set(long index, byte value) {
            ARRAY_HANDLE.setVolatile(this.page, (int)index, value);
        }

        @Override
        public boolean compareAndSet(long index, byte expect, byte update) {
            return ARRAY_HANDLE.compareAndSet(this.page, (int)index, expect, update);
        }

        @Override
        public byte compareAndExchange(long index, byte expect, byte update) {
            return ARRAY_HANDLE.compareAndExchange(this.page, (int)index, expect, update);
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public long sizeOf() {
            return MemoryUsage.sizeOfByteArray((long)this.size);
        }

        @Override
        public void setAll(byte value) {
            Arrays.fill(this.page, value);
            VarHandle.storeStoreFence();
        }

        @Override
        public long release() {
            if (this.page != null) {
                this.page = null;
                return MemoryUsage.sizeOfByteArray((long)this.size);
            }
            return 0L;
        }
    }
}

