/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.function.LongConsumer;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.HugeCursor;

public final class HugeAtomicBitSetOps {
    private static final int NUM_BITS = 64;

    static boolean get(HugeAtomicLongArray bits, long numBits, long index) {
        assert (index < numBits);
        long wordIndex = index / 64L;
        int bitIndex = (int)index % 64;
        long bitmask = 1L << bitIndex;
        return (bits.get(wordIndex) & bitmask) != 0L;
    }

    static void set(HugeAtomicLongArray bits, long numBits, long index) {
        assert (index < numBits);
        long wordIndex = index / 64L;
        int bitIndex = (int)index % 64;
        long bitmask = 1L << bitIndex;
        long oldWord = bits.get(wordIndex);
        long newWord;
        while ((newWord = oldWord | bitmask) != oldWord) {
            long currentWord = bits.compareAndExchange(wordIndex, oldWord, newWord);
            if (currentWord == oldWord) {
                return;
            }
            oldWord = currentWord;
        }
        return;
    }

    static void setRange(HugeAtomicLongArray bits, long numBits, long startIndex, long endIndex) {
        assert (startIndex <= endIndex);
        assert (endIndex <= numBits);
        long startWordIndex = startIndex / 64L;
        long endWordIndex = (endIndex - 1L) / 64L;
        long startBitMask = -1L << (int)startIndex;
        long endBitMask = -1L >>> (int)(-endIndex);
        if (startWordIndex == endWordIndex) {
            HugeAtomicBitSetOps.setWord(bits, startWordIndex, startBitMask & endBitMask);
        } else {
            HugeAtomicBitSetOps.setWord(bits, startWordIndex, startBitMask);
            for (long wordIndex = startWordIndex + 1L; wordIndex < endWordIndex; ++wordIndex) {
                bits.set(wordIndex, -1L);
            }
            HugeAtomicBitSetOps.setWord(bits, endWordIndex, endBitMask);
        }
    }

    private static void setWord(HugeAtomicLongArray bits, long wordIndex, long bitMask) {
        long oldWord = bits.get(wordIndex);
        long newWord;
        while ((newWord = oldWord | bitMask) != oldWord) {
            long currentWord = bits.compareAndExchange(wordIndex, oldWord, newWord);
            if (currentWord == oldWord) {
                return;
            }
            oldWord = currentWord;
        }
        return;
    }

    static boolean getAndSet(HugeAtomicLongArray bits, long numBits, long index) {
        assert (index < numBits);
        long wordIndex = index / 64L;
        int bitIndex = (int)index % 64;
        long bitmask = 1L << bitIndex;
        long oldWord = bits.get(wordIndex);
        long newWord;
        while ((newWord = oldWord | bitmask) != oldWord) {
            long currentWord = bits.compareAndExchange(wordIndex, oldWord, newWord);
            if (currentWord == oldWord) {
                return false;
            }
            oldWord = currentWord;
        }
        return true;
    }

    static void flip(HugeAtomicLongArray bits, long numBits, long index) {
        assert (index < numBits);
        long wordIndex = index / 64L;
        int bitIndex = (int)index % 64;
        long bitmask = 1L << bitIndex;
        long oldWord = bits.get(wordIndex);
        long newWord;
        long currentWord;
        while ((currentWord = bits.compareAndExchange(wordIndex, oldWord, newWord = oldWord ^ bitmask)) != oldWord) {
            oldWord = currentWord;
        }
        return;
    }

    static void forEachSetBit(HugeAtomicLongArray bits, LongConsumer consumer) {
        HugeCursor<long[]> cursor = bits.initCursor(bits.newCursor());
        while (cursor.next()) {
            long[] block = (long[])cursor.array;
            int offset = cursor.offset;
            int limit = cursor.limit;
            long base = cursor.base;
            for (int i = offset; i < limit; ++i) {
                for (long word = block[i]; word != 0L; word ^= Long.lowestOneBit(word)) {
                    long next = Long.numberOfTrailingZeros(word);
                    consumer.accept(64L * (base + (long)i) + next);
                }
            }
        }
    }

    static long cardinality(HugeAtomicLongArray bits) {
        long setBitCount = 0L;
        for (long wordIndex = 0L; wordIndex < bits.size(); ++wordIndex) {
            setBitCount += (long)Long.bitCount(bits.get(wordIndex));
        }
        return setBitCount;
    }

    static boolean isEmpty(HugeAtomicLongArray bits) {
        for (long wordIndex = 0L; wordIndex < bits.size(); ++wordIndex) {
            if (Long.bitCount(bits.get(wordIndex)) <= 0) continue;
            return false;
        }
        return true;
    }

    static boolean allSet(HugeAtomicLongArray bits, long remainder) {
        for (long wordIndex = 0L; wordIndex < bits.size() - 1L; ++wordIndex) {
            if (Long.bitCount(bits.get(wordIndex)) >= 64) continue;
            return false;
        }
        return (long)Long.bitCount(bits.get(bits.size() - 1L)) >= remainder;
    }

    static void clear(HugeAtomicLongArray bits) {
        bits.setAll(0L);
    }

    static void clear(HugeAtomicLongArray bits, long numBits, long index) {
        assert (index < numBits);
        long wordIndex = index / 64L;
        int bitIndex = (int)index % 64;
        long bitmask = 1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL;
        long oldWord = bits.get(wordIndex);
        long newWord;
        while ((newWord = oldWord & bitmask) != oldWord) {
            long currentWord = bits.compareAndExchange(wordIndex, oldWord, newWord);
            if (currentWord == oldWord) {
                return;
            }
            oldWord = currentWord;
        }
        return;
    }

    private HugeAtomicBitSetOps() {
    }
}

