/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.function.LongConsumer;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSetOps;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.mem.BitUtil;
import org.neo4j.gds.mem.MemoryUsage;

public final class HugeAtomicBitSet {
    private static final int NUM_BITS = 64;
    private final HugeAtomicLongArray bits;
    private final long numBits;
    private final int remainder;

    public static long memoryEstimation(long size) {
        long wordsSize = BitUtil.ceilDiv((long)size, (long)64L);
        return HugeAtomicLongArray.memoryEstimation(wordsSize) + MemoryUsage.sizeOfInstance(HugeAtomicBitSet.class);
    }

    public static HugeAtomicBitSet create(long size) {
        long wordsSize = BitUtil.ceilDiv((long)size, (long)64L);
        int remainder = (int)(size % 64L);
        return new HugeAtomicBitSet(HugeAtomicLongArray.newArray(wordsSize), size, remainder);
    }

    private HugeAtomicBitSet(HugeAtomicLongArray bits, long numBits, int remainder) {
        this.bits = bits;
        this.numBits = numBits;
        this.remainder = remainder;
    }

    public boolean get(long index) {
        return HugeAtomicBitSetOps.get(this.bits, this.numBits, index);
    }

    public void set(long index) {
        HugeAtomicBitSetOps.set(this.bits, this.numBits, index);
    }

    public void set(long startIndex, long endIndex) {
        HugeAtomicBitSetOps.setRange(this.bits, this.numBits, startIndex, endIndex);
    }

    public boolean getAndSet(long index) {
        return HugeAtomicBitSetOps.getAndSet(this.bits, this.numBits, index);
    }

    public void flip(long index) {
        HugeAtomicBitSetOps.flip(this.bits, this.numBits, index);
    }

    public void forEachSetBit(LongConsumer consumer) {
        HugeAtomicBitSetOps.forEachSetBit(this.bits, consumer);
    }

    public long cardinality() {
        return HugeAtomicBitSetOps.cardinality(this.bits);
    }

    public boolean isEmpty() {
        return HugeAtomicBitSetOps.isEmpty(this.bits);
    }

    public boolean allSet() {
        return HugeAtomicBitSetOps.allSet(this.bits, this.remainder);
    }

    public long size() {
        return this.numBits;
    }

    public void clear() {
        HugeAtomicBitSetOps.clear(this.bits);
    }

    public void clear(long index) {
        HugeAtomicBitSetOps.clear(this.bits, this.numBits, index);
    }
}

