/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import org.neo4j.gds.mem.MemoryUsage;

public final class HugeArrays {
    static final int PAGE_SHIFT = 14;
    public static final int PAGE_SIZE = 16384;
    private static final long PAGE_MASK = 16383L;

    static int pageIndex(long index) {
        return (int)(index >>> 14);
    }

    static int indexInPage(long index) {
        return (int)(index & 0x3FFFL);
    }

    public static int exclusiveIndexOfPage(long index) {
        return 1 + (int)(index - 1L & 0x3FFFL);
    }

    static long indexFromPageIndexAndIndexInPage(int pageIndex, int indexInPage) {
        return pageIndex << 14 | indexInPage;
    }

    public static int numberOfPages(long capacity) {
        long numPages = capacity + 16383L >>> 14;
        assert (numPages <= Integer.MAX_VALUE) : "pageSize=16384 is too small for capacity: " + capacity;
        return (int)numPages;
    }

    public static long oversize(long minTargetSize, int bytesPerElement) {
        if (minTargetSize == 0L) {
            return 0L;
        }
        long extra = minTargetSize >> 3;
        if (extra < 3L) {
            extra = 3L;
        }
        long newSize = minTargetSize + extra;
        if (MemoryUsage.BYTES_OBJECT_REF == 8) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1L & 0x7FFFFFFEL;
                }
                case 2: {
                    return newSize + 3L & 0x7FFFFFFCL;
                }
                case 1: {
                    return newSize + 7L & 0x7FFFFFF8L;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 2: {
                return newSize + 1L & 0x7FFFFFFEL;
            }
            case 1: {
                return newSize + 3L & 0x7FFFFFFCL;
            }
        }
        return newSize;
    }

    public static int oversizeInt(int minTargetSize, int bytesPerElement) {
        return Math.toIntExact(HugeArrays.oversize(minTargetSize, bytesPerElement));
    }

    private HugeArrays() {
        throw new UnsupportedOperationException("No instances");
    }
}

