/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.lang.reflect.Array;
import java.util.function.LongFunction;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeCursorSupport;

public abstract class HugeArray<Array, Box, Self extends HugeArray<Array, Box, Self>>
implements HugeCursorSupport<Array> {
    public abstract void copyTo(Self var1, long var2);

    public abstract Self copyOf(long var1);

    @Override
    public abstract long size();

    public abstract long sizeOf();

    public abstract long release();

    abstract Box boxedGet(long var1);

    abstract void boxedSet(long var1, Box var3);

    abstract void boxedSetAll(LongFunction<Box> var1);

    abstract void boxedFill(Box var1);

    public abstract Array toArray();

    public abstract NodePropertyValues asNodeProperties();

    public final int copyFromArrayIntoSlice(Array source, long sliceStart, long sliceEnd) {
        int sourceIndex;
        try (HugeCursor cursor = this.initCursor(this.newCursor(), sliceStart, sliceEnd);){
            int copyLength;
            int sourceLength = Array.getLength(source);
            for (sourceIndex = 0; cursor.next() && sourceIndex < sourceLength; sourceIndex += copyLength) {
                copyLength = Math.min(cursor.limit - cursor.offset, sourceLength - sourceIndex);
                System.arraycopy(source, sourceIndex, cursor.array, cursor.offset, copyLength);
            }
        }
        return sourceIndex;
    }

    public String toString() {
        if (this.size() == 0L) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        try (HugeCursor cursor = this.initCursor(this.newCursor());){
            while (cursor.next()) {
                Object array = cursor.array;
                for (int i = cursor.offset; i < cursor.limit; ++i) {
                    sb.append(Array.get(array, i)).append(", ");
                }
            }
        }
        sb.setLength(sb.length() - 1);
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    Array dumpToArray(Class<Array> componentClass) {
        long fullSize = this.size();
        if ((long)((int)fullSize) != fullSize) {
            throw new IllegalStateException("array with " + fullSize + " elements does not fit into a Java array");
        }
        int size = (int)fullSize;
        Object result = Array.newInstance(componentClass.getComponentType(), size);
        int pos = 0;
        try (HugeCursor cursor = this.initCursor(this.newCursor());){
            while (cursor.next()) {
                Object array = cursor.array;
                int length = cursor.limit - cursor.offset;
                System.arraycopy(array, cursor.offset, result, pos, length);
                pos += length;
            }
        }
        return (Array)result;
    }
}

