/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.function.DoubleUnaryOperator;
import java.util.stream.IntStream;
import org.neo4j.gds.core.concurrency.ParallelUtil;

public final class DoublePageCreator {
    private final int concurrency;
    private final DoubleUnaryOperator gen;

    private DoublePageCreator(int concurrency, DoubleUnaryOperator gen) {
        this.concurrency = concurrency;
        this.gen = gen;
    }

    public void fill(double[][] pages, int lastPageSize) {
        int lastPageIndex = pages.length - 1;
        ParallelUtil.parallelStreamConsume(IntStream.range(0, lastPageIndex), this.concurrency, stream -> stream.forEach(pageIndex -> this.createAndFillPage(pages, pageIndex, 16384)));
        this.createAndFillPage(pages, lastPageIndex, lastPageSize);
    }

    public void fillPage(double[] page, long base) {
        if (this.gen != null) {
            for (int i = 0; i < page.length; ++i) {
                page[i] = this.gen.applyAsDouble((long)i + base);
            }
        }
    }

    private void createAndFillPage(double[][] pages, int pageIndex, int pageSize) {
        double[] page = new double[pageSize];
        pages[pageIndex] = page;
        long base = (long)pageIndex << 14;
        this.fillPage(page, base);
    }

    public static DoublePageCreator of(int concurrency, DoubleUnaryOperator gen) {
        return new DoublePageCreator(concurrency, gen);
    }

    public static DoublePageCreator identity(int concurrency) {
        return new DoublePageCreator(concurrency, i -> i);
    }

    public static DoublePageCreator passThrough(int concurrency) {
        return new DoublePageCreator(concurrency, null);
    }
}

