/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.paged;

import java.util.stream.IntStream;
import org.neo4j.gds.core.concurrency.ParallelUtil;

public final class BytePageCreator {
    private final int concurrency;

    private BytePageCreator(int concurrency) {
        this.concurrency = concurrency;
    }

    public void fill(byte[][] pages, int lastPageSize) {
        int lastPageIndex = pages.length - 1;
        ParallelUtil.parallelStreamConsume(IntStream.range(0, lastPageIndex), this.concurrency, stream -> stream.forEach(pageIndex -> this.createPage(pages, pageIndex, 16384)));
        this.createPage(pages, lastPageIndex, lastPageSize);
    }

    private void createPage(byte[][] pages, int pageIndex, int pageSize) {
        byte[] page = new byte[pageSize];
        pages[pageIndex] = page;
    }

    public static BytePageCreator of(int concurrency) {
        return new BytePageCreator(concurrency);
    }
}

