/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.mem;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.core.utils.mem.GcListener;
import org.neo4j.logging.internal.LogService;

final class HotSpotGcListener {
    private static final boolean ENABLED;
    private static final String GC_NOTIFICATION_NAME;
    private static final MethodHandle GET_USAGE_AFTER_GC;

    static Optional<NotificationListener> install(LogService logService, AtomicLong freeMemory, String[] poolNames, NotificationBroadcaster broadcaster) {
        if (ENABLED) {
            GcListener listener = new GcListener(Neo4jProxy.getInternalLog((LogService)logService, GcListener.class), freeMemory, poolNames, GC_NOTIFICATION_NAME, GET_USAGE_AFTER_GC);
            broadcaster.addNotificationListener(listener, listener, null);
            return Optional.of(listener);
        }
        return Optional.empty();
    }

    private HotSpotGcListener() {
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String gcNotificationName = null;
        MethodHandle getUsageAfterGc = null;
        boolean enabled = false;
        try {
            Class<?> gcNotifyClass = Class.forName("com.sun.management.GarbageCollectionNotificationInfo");
            MethodHandle notificationNameField = lookup.findStaticGetter(gcNotifyClass, "GARBAGE_COLLECTION_NOTIFICATION", String.class);
            try {
                gcNotificationName = String.valueOf(notificationNameField.invoke());
            }
            catch (Throwable ignored) {
                gcNotificationName = "com.sun.management.gc.notification";
            }
            MethodHandle infoMethod = lookup.findStatic(gcNotifyClass, "from", MethodType.methodType(gcNotifyClass, CompositeData.class));
            Class<?> gcInfoClass = Class.forName("com.sun.management.GcInfo");
            MethodHandle getGcInfo = lookup.findVirtual(gcNotifyClass, "getGcInfo", MethodType.methodType(gcInfoClass));
            getGcInfo = MethodHandles.filterReturnValue(infoMethod, getGcInfo);
            MethodHandle getMemoryUsageAfterGc = lookup.findVirtual(gcInfoClass, "getMemoryUsageAfterGc", MethodType.methodType(Map.class));
            getUsageAfterGc = getMemoryUsageAfterGc = MethodHandles.filterReturnValue(getGcInfo, getMemoryUsageAfterGc);
            enabled = true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        GC_NOTIFICATION_NAME = gcNotificationName;
        GET_USAGE_AFTER_GC = getUsageAfterGc;
        ENABLED = enabled;
    }
}

