/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.mem;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationListener;
import org.neo4j.gds.core.utils.mem.HotSpotGcListener;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.internal.LogService;

final class GcListenerInstaller
extends LifecycleAdapter {
    private final LogService logService;
    private final List<GarbageCollectorMXBean> gcBeans;
    private final AtomicLong freeMemory;
    private final Map<NotificationBroadcaster, NotificationListener> registeredListeners;

    GcListenerInstaller(LogService logService, Collection<GarbageCollectorMXBean> gcBeans, AtomicLong freeMemory) {
        this.logService = logService;
        this.gcBeans = new ArrayList<GarbageCollectorMXBean>(gcBeans);
        this.freeMemory = freeMemory;
        this.registeredListeners = new IdentityHashMap<NotificationBroadcaster, NotificationListener>();
    }

    public void init() {
        for (GarbageCollectorMXBean gcBean : this.gcBeans) {
            this.installGcListener(gcBean);
        }
    }

    public void shutdown() {
        this.registeredListeners.forEach(this::uninstallGcListener);
    }

    private void installGcListener(MemoryManagerMXBean gcBean) {
        if (gcBean instanceof NotificationBroadcaster) {
            NotificationBroadcaster broadcaster = (NotificationBroadcaster)((Object)gcBean);
            Optional<NotificationListener> listener = HotSpotGcListener.install(this.logService, this.freeMemory, gcBean.getMemoryPoolNames(), broadcaster);
            listener.ifPresent(notificationListener -> this.registeredListeners.put(broadcaster, (NotificationListener)notificationListener));
        }
    }

    private void uninstallGcListener(NotificationBroadcaster gcBean, NotificationListener listener) {
        try {
            gcBean.removeNotificationListener(listener);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }
}

