/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.mem;

import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.core.utils.mem.GcListenerInstaller;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.internal.LogService;

public final class GcListenerExtension
extends ExtensionFactory<Dependencies> {
    private static final AtomicLong freeMemoryAfterLastGc = new AtomicLong(Runtime.getRuntime().maxMemory());

    public GcListenerExtension() {
        super("gds.heap-control.gc-listener");
    }

    public static long freeMemory() {
        return freeMemoryAfterLastGc.get();
    }

    public Lifecycle newInstance(ExtensionContext context, Dependencies dependencies) {
        return new GcListenerInstaller(dependencies.logService(), ManagementFactory.getGarbageCollectorMXBeans(), freeMemoryAfterLastGc);
    }

    static interface Dependencies {
        public LogService logService();
    }
}

