/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils.mem;

import java.lang.invoke.MethodHandle;
import java.lang.management.MemoryUsage;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.neo4j.logging.Log;

final class GcListener
implements NotificationListener,
NotificationFilter {
    private static final long serialVersionUID = 133742L;
    private final Log log;
    private final AtomicLong freeMemory;
    private final String[] poolNames;
    private final String gcNotificationName;
    private final MethodHandle getMemoryUsage;
    private final AtomicBoolean reflectionWarningEmitted;

    GcListener(Log log, AtomicLong freeMemory, String[] poolNames, String gcNotificationName, MethodHandle getMemoryUsage) {
        this.log = log;
        this.freeMemory = freeMemory;
        this.poolNames = poolNames;
        this.gcNotificationName = gcNotificationName;
        this.getMemoryUsage = getMemoryUsage;
        this.reflectionWarningEmitted = new AtomicBoolean(false);
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        return notification.getType().equals(this.gcNotificationName);
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        Map afterGc;
        block6: {
            Object notificationData = notification.getUserData();
            if (!(notificationData instanceof CompositeData)) {
                return;
            }
            CompositeData userData = (CompositeData)notificationData;
            afterGc = null;
            try {
                Map usage;
                afterGc = usage = this.getMemoryUsage.invoke(userData);
            }
            catch (Throwable throwable) {
                if (!this.reflectionWarningEmitted.compareAndSet(false, true)) break block6;
                this.log.warn("Could not convert the notification data into a memory usage map", throwable);
            }
        }
        if (afterGc == null) {
            return;
        }
        long freeAfterGc = 0L;
        for (String poolName : this.poolNames) {
            MemoryUsage usageAfterGc = (MemoryUsage)afterGc.get(poolName);
            if (usageAfterGc == null) continue;
            long maxPoolSize = usageAfterGc.getMax();
            if (maxPoolSize != -1L) {
                freeAfterGc += maxPoolSize;
            }
            freeAfterGc -= usageAfterGc.getUsed();
        }
        this.log.debug("Free pool memory after GC: %d", new Object[]{freeAfterGc});
        this.freeMemory.set(freeAfterGc);
    }
}

